/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.runner;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestResult;
import com.consol.citrus.actions.AntRunAction;
import com.consol.citrus.actions.CreateVariablesAction;
import com.consol.citrus.actions.EchoAction;
import com.consol.citrus.actions.ExecutePLSQLAction;
import com.consol.citrus.actions.ExecuteSQLAction;
import com.consol.citrus.actions.ExecuteSQLQueryAction;
import com.consol.citrus.actions.FailAction;
import com.consol.citrus.actions.InputAction;
import com.consol.citrus.actions.LoadPropertiesAction;
import com.consol.citrus.actions.PurgeEndpointAction;
import com.consol.citrus.actions.PurgeMessageChannelAction;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.actions.ReceiveTimeoutAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.actions.SleepAction;
import com.consol.citrus.actions.StartServerAction;
import com.consol.citrus.actions.StopServerAction;
import com.consol.citrus.actions.StopTimeAction;
import com.consol.citrus.actions.StopTimerAction;
import com.consol.citrus.actions.TraceVariablesAction;
import com.consol.citrus.actions.TransformAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.SequenceAfterTest;
import com.consol.citrus.container.SequenceBeforeTest;
import com.consol.citrus.container.Template;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.container.Wait;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.AbstractTestContainerBuilder;
import com.consol.citrus.dsl.builder.AntRunBuilder;
import com.consol.citrus.dsl.builder.AssertExceptionBuilder;
import com.consol.citrus.dsl.builder.AssertSoapFaultBuilder;
import com.consol.citrus.dsl.builder.AsyncBuilder;
import com.consol.citrus.dsl.builder.BuilderSupport;
import com.consol.citrus.dsl.builder.CamelRouteActionBuilder;
import com.consol.citrus.dsl.builder.CatchExceptionBuilder;
import com.consol.citrus.dsl.builder.ConditionalBuilder;
import com.consol.citrus.dsl.builder.DockerActionBuilder;
import com.consol.citrus.dsl.builder.ExecutePLSQLBuilder;
import com.consol.citrus.dsl.builder.ExecuteSQLBuilder;
import com.consol.citrus.dsl.builder.ExecuteSQLQueryBuilder;
import com.consol.citrus.dsl.builder.FinallySequenceBuilder;
import com.consol.citrus.dsl.builder.GroovyActionBuilder;
import com.consol.citrus.dsl.builder.HttpActionBuilder;
import com.consol.citrus.dsl.builder.InputActionBuilder;
import com.consol.citrus.dsl.builder.IterateBuilder;
import com.consol.citrus.dsl.builder.KubernetesActionBuilder;
import com.consol.citrus.dsl.builder.ParallelBuilder;
import com.consol.citrus.dsl.builder.PurgeChannelsBuilder;
import com.consol.citrus.dsl.builder.PurgeEndpointsBuilder;
import com.consol.citrus.dsl.builder.PurgeJmsQueuesBuilder;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.dsl.builder.ReceiveTimeoutBuilder;
import com.consol.citrus.dsl.builder.RepeatBuilder;
import com.consol.citrus.dsl.builder.RepeatOnErrorBuilder;
import com.consol.citrus.dsl.builder.SeleniumActionBuilder;
import com.consol.citrus.dsl.builder.SendMessageBuilder;
import com.consol.citrus.dsl.builder.SequenceBuilder;
import com.consol.citrus.dsl.builder.SoapActionBuilder;
import com.consol.citrus.dsl.builder.TemplateBuilder;
import com.consol.citrus.dsl.builder.TimerBuilder;
import com.consol.citrus.dsl.builder.TransformActionBuilder;
import com.consol.citrus.dsl.builder.WaitBuilder;
import com.consol.citrus.dsl.builder.ZooActionBuilder;
import com.consol.citrus.dsl.container.FinallySequence;
import com.consol.citrus.dsl.runner.ApplyTestBehaviorAction;
import com.consol.citrus.dsl.runner.TestBehavior;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.report.TestActionListeners;
import com.consol.citrus.script.GroovyAction;
import com.consol.citrus.server.Server;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public class DefaultTestRunner
implements TestRunner {
    private static Logger log = LoggerFactory.getLogger(DefaultTestRunner.class);
    private final TestCase testCase;
    private TestContext context;
    private ApplicationContext applicationContext;
    protected Stack<AbstractActionContainer> containers = new Stack();

    public DefaultTestRunner() {
        this(new TestCase());
        this.testClass(this.getClass());
        this.name(this.getClass().getSimpleName());
        this.packageName(this.getClass().getPackage().getName());
    }

    protected DefaultTestRunner(TestCase testCase) {
        this.testCase = testCase;
    }

    public DefaultTestRunner(ApplicationContext applicationContext, TestContext context) {
        this();
        this.applicationContext = applicationContext;
        this.context = context;
        try {
            this.initialize();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to setup test runner", (Throwable)e);
        }
    }

    protected void initialize() {
        this.testCase.setTestRunner(true);
        this.testCase.setTestActionListeners((TestActionListeners)this.applicationContext.getBean(TestActionListeners.class));
        if (!this.applicationContext.getBeansOfType(SequenceBeforeTest.class).isEmpty()) {
            this.testCase.setBeforeTest(CollectionUtils.arrayToList((Object)this.applicationContext.getBeansOfType(SequenceBeforeTest.class).values().toArray()));
        }
        if (!this.applicationContext.getBeansOfType(SequenceAfterTest.class).isEmpty()) {
            this.testCase.setAfterTest(CollectionUtils.arrayToList((Object)this.applicationContext.getBeansOfType(SequenceAfterTest.class).values().toArray()));
        }
    }

    @Override
    public void testClass(Class<?> type) {
        this.getTestCase().setTestClass(type);
    }

    @Override
    public void name(String name) {
        this.testCase.setBeanName(name);
        this.testCase.setName(name);
    }

    @Override
    public void description(String description) {
        this.getTestCase().setDescription(description);
    }

    @Override
    public void author(String author) {
        this.getTestCase().getMetaInfo().setAuthor(author);
    }

    @Override
    public void packageName(String packageName) {
        this.getTestCase().setPackageName(packageName);
    }

    @Override
    public void status(TestCaseMetaInfo.Status status) {
        this.getTestCase().getMetaInfo().setStatus(status);
    }

    @Override
    public void creationDate(Date date) {
        this.getTestCase().getMetaInfo().setCreationDate(date);
    }

    @Override
    public void start() {
        this.testCase.start(this.context);
    }

    @Override
    public void stop() {
        try {
            if (!CollectionUtils.isEmpty((Collection)this.context.getExceptions())) {
                CitrusRuntimeException ex = (CitrusRuntimeException)this.context.getExceptions().remove(0);
                this.testCase.setTestResult(TestResult.failed((String)this.testCase.getName(), (String)this.testCase.getTestClass().getName(), (Throwable)ex));
                throw new TestCaseFailedException((Throwable)ex);
            }
        }
        finally {
            this.testCase.finish(this.context);
        }
    }

    @Override
    public <T> T variable(String name, T value) {
        this.testCase.getVariableDefinitions().put(name, value);
        if (value instanceof String) {
            String resolved = this.context.replaceDynamicContentInString(value.toString());
            this.context.setVariable(name, (Object)resolved);
            return (T)resolved;
        }
        this.context.setVariable(name, value);
        return value;
    }

    @Override
    public <T extends TestAction> T run(T testAction) {
        if (testAction instanceof TestActionContainer) {
            if (!((AbstractActionContainer)this.containers.lastElement()).equals(testAction)) {
                throw new CitrusRuntimeException("Invalid use of action containers - the container execution is not expected!");
            }
            this.containers.pop();
            if (testAction instanceof FinallySequence) {
                this.testCase.getFinalActions().addAll(((FinallySequence)testAction).getActions());
                return testAction;
            }
        }
        if (!this.containers.isEmpty()) {
            ((AbstractActionContainer)this.containers.lastElement()).addTestAction(testAction);
        } else {
            this.testCase.addTestAction(testAction);
            this.testCase.executeAction(testAction, this.context);
        }
        return testAction;
    }

    @Override
    public ApplyTestBehaviorAction applyBehavior(TestBehavior behavior) {
        ApplyTestBehaviorAction action = new ApplyTestBehaviorAction(this, behavior);
        behavior.setApplicationContext(this.applicationContext);
        action.execute(this.context);
        return action;
    }

    @Override
    public <T extends AbstractActionContainer> AbstractTestContainerBuilder<T> container(T container) {
        AbstractTestContainerBuilder containerBuilder = new AbstractTestContainerBuilder<T>(this, container){};
        this.containers.push((AbstractActionContainer)containerBuilder.build());
        return containerBuilder;
    }

    @Override
    public CreateVariablesAction createVariable(String variableName, String value) {
        CreateVariablesAction action = new CreateVariablesAction();
        action.getVariables().put(variableName, value);
        return this.run(action);
    }

    @Override
    public AntRunAction antrun(BuilderSupport<AntRunBuilder> configurer) {
        AntRunBuilder builder = new AntRunBuilder();
        configurer.configure(builder);
        return (AntRunAction)this.run(builder.build());
    }

    @Override
    public EchoAction echo(String message) {
        EchoAction action = new EchoAction();
        action.setMessage(message);
        return this.run(action);
    }

    @Override
    public ExecutePLSQLAction plsql(BuilderSupport<ExecutePLSQLBuilder> configurer) {
        ExecutePLSQLBuilder builder = new ExecutePLSQLBuilder();
        configurer.configure(builder);
        return (ExecutePLSQLAction)this.run(builder.build());
    }

    @Override
    public ExecuteSQLAction sql(BuilderSupport<ExecuteSQLBuilder> configurer) {
        ExecuteSQLBuilder builder = new ExecuteSQLBuilder();
        configurer.configure(builder);
        return (ExecuteSQLAction)this.run(builder.build());
    }

    @Override
    public ExecuteSQLQueryAction query(BuilderSupport<ExecuteSQLQueryBuilder> configurer) {
        ExecuteSQLQueryBuilder builder = new ExecuteSQLQueryBuilder();
        configurer.configure(builder);
        return (ExecuteSQLQueryAction)this.run(builder.build());
    }

    @Override
    public FailAction fail(String message) {
        FailAction action = new FailAction();
        action.setMessage(message);
        return this.run(action);
    }

    @Override
    public InputAction input(BuilderSupport<InputActionBuilder> configurer) {
        InputActionBuilder builder = new InputActionBuilder();
        configurer.configure(builder);
        return (InputAction)this.run(builder.build());
    }

    @Override
    public ReceiveTimeoutAction receiveTimeout(BuilderSupport<ReceiveTimeoutBuilder> configurer) {
        ReceiveTimeoutBuilder builder = new ReceiveTimeoutBuilder();
        configurer.configure(builder);
        return (ReceiveTimeoutAction)this.run(builder.build());
    }

    @Override
    public LoadPropertiesAction load(String filePath) {
        LoadPropertiesAction action = new LoadPropertiesAction();
        action.setFilePath(filePath);
        return this.run(action);
    }

    @Override
    public TestAction purgeQueues(BuilderSupport<PurgeJmsQueuesBuilder> configurer) {
        PurgeJmsQueuesBuilder builder = new PurgeJmsQueuesBuilder().withApplicationContext(this.applicationContext);
        configurer.configure(builder);
        return this.run(builder.build());
    }

    @Override
    public PurgeMessageChannelAction purgeChannels(BuilderSupport<PurgeChannelsBuilder> configurer) {
        PurgeChannelsBuilder builder = new PurgeChannelsBuilder();
        builder.channelResolver(this.applicationContext);
        configurer.configure(builder);
        return (PurgeMessageChannelAction)this.run(builder.build());
    }

    @Override
    public PurgeEndpointAction purgeEndpoints(BuilderSupport<PurgeEndpointsBuilder> configurer) {
        PurgeEndpointsBuilder builder = new PurgeEndpointsBuilder().withApplicationContext(this.applicationContext);
        configurer.configure(builder);
        return (PurgeEndpointAction)this.run(builder.build());
    }

    @Override
    public ReceiveMessageAction receive(BuilderSupport<ReceiveMessageBuilder> configurer) {
        Object builder = ((ReceiveMessageBuilder)new ReceiveMessageBuilder().messageType(MessageType.XML)).withApplicationContext(this.applicationContext);
        configurer.configure((ReceiveMessageBuilder)builder);
        return (ReceiveMessageAction)this.run(((DelegatingTestAction)((Object)((AbstractTestActionBuilder)builder).build())).getDelegate());
    }

    @Override
    public SendMessageAction send(BuilderSupport<SendMessageBuilder> configurer) {
        Object builder = new SendMessageBuilder().withApplicationContext(this.applicationContext);
        configurer.configure((SendMessageBuilder)builder);
        return (SendMessageAction)this.run(((DelegatingTestAction)((Object)((AbstractTestActionBuilder)builder).build())).getDelegate());
    }

    @Override
    public SleepAction sleep() {
        return this.run(new SleepAction());
    }

    @Override
    public SleepAction sleep(long milliseconds) {
        SleepAction action = new SleepAction();
        action.setMilliseconds(String.valueOf(milliseconds));
        return this.run(action);
    }

    @Override
    @Deprecated
    public Wait waitFor(BuilderSupport<WaitBuilder> configurer) {
        WaitBuilder builder = new WaitBuilder(null, new Wait());
        configurer.configure(builder);
        this.containers.push((AbstractActionContainer)builder.build());
        return (Wait)this.run(builder.build());
    }

    @Override
    public WaitBuilder waitFor() {
        WaitBuilder builder = new WaitBuilder((TestRunner)this, new Wait());
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public StartServerAction start(Server ... servers) {
        StartServerAction action = new StartServerAction();
        action.getServerList().addAll(Arrays.asList(servers));
        return this.run(action);
    }

    @Override
    public StartServerAction start(Server server) {
        StartServerAction action = new StartServerAction();
        action.setServer(server);
        return this.run(action);
    }

    @Override
    public StopServerAction stop(Server ... servers) {
        StopServerAction action = new StopServerAction();
        action.getServerList().addAll(Arrays.asList(servers));
        return this.run(action);
    }

    @Override
    public StopServerAction stop(Server server) {
        StopServerAction action = new StopServerAction();
        action.setServer(server);
        return this.run(action);
    }

    @Override
    public StopTimeAction stopTime() {
        return this.run(new StopTimeAction());
    }

    @Override
    public StopTimeAction stopTime(String id) {
        StopTimeAction action = new StopTimeAction();
        action.setId(id);
        return this.run(action);
    }

    @Override
    public StopTimeAction stopTime(String id, String suffix) {
        StopTimeAction action = new StopTimeAction();
        action.setId(id);
        action.setSuffix(suffix);
        return this.run(action);
    }

    @Override
    public TraceVariablesAction traceVariables() {
        return this.run(new TraceVariablesAction());
    }

    @Override
    public TraceVariablesAction traceVariables(String ... variables) {
        TraceVariablesAction action = new TraceVariablesAction();
        action.setVariableNames(Arrays.asList(variables));
        return this.run(action);
    }

    @Override
    public GroovyAction groovy(BuilderSupport<GroovyActionBuilder> configurer) {
        GroovyActionBuilder builder = new GroovyActionBuilder();
        configurer.configure(builder);
        return (GroovyAction)this.run(builder.build());
    }

    @Override
    public TransformAction transform(BuilderSupport<TransformActionBuilder> configurer) {
        TransformActionBuilder builder = new TransformActionBuilder();
        configurer.configure(builder);
        return (TransformAction)this.run(builder.build());
    }

    @Override
    public AssertExceptionBuilder assertException() {
        AssertExceptionBuilder builder = new AssertExceptionBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public CatchExceptionBuilder catchException() {
        CatchExceptionBuilder builder = new CatchExceptionBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public AssertSoapFaultBuilder assertSoapFault() {
        AssertSoapFaultBuilder builder = new AssertSoapFaultBuilder(this).withApplicationContext(this.applicationContext);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public ConditionalBuilder conditional() {
        ConditionalBuilder builder = new ConditionalBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public IterateBuilder iterate() {
        IterateBuilder builder = new IterateBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public ParallelBuilder parallel() {
        ParallelBuilder builder = new ParallelBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public RepeatOnErrorBuilder repeatOnError() {
        RepeatOnErrorBuilder builder = new RepeatOnErrorBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public RepeatBuilder repeat() {
        RepeatBuilder builder = new RepeatBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public SequenceBuilder sequential() {
        SequenceBuilder builder = new SequenceBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public AsyncBuilder async() {
        AsyncBuilder builder = new AsyncBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public TimerBuilder timer() {
        TimerBuilder builder = new TimerBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    @Override
    public StopTimerAction stopTimer(String timerId) {
        StopTimerAction action = new StopTimerAction();
        action.setTimerId(timerId);
        return this.run(action);
    }

    @Override
    public StopTimerAction stopTimers() {
        StopTimerAction action = new StopTimerAction();
        return this.run(action);
    }

    @Override
    public TestAction docker(BuilderSupport<DockerActionBuilder> configurer) {
        DockerActionBuilder builder = new DockerActionBuilder();
        configurer.configure(builder);
        return this.run(builder.build());
    }

    @Override
    public TestAction kubernetes(BuilderSupport<KubernetesActionBuilder> configurer) {
        KubernetesActionBuilder builder = new KubernetesActionBuilder();
        configurer.configure(builder);
        return this.run(builder.build());
    }

    @Override
    public TestAction selenium(BuilderSupport<SeleniumActionBuilder> configurer) {
        SeleniumActionBuilder builder = new SeleniumActionBuilder();
        configurer.configure(builder);
        return this.run(builder.build());
    }

    @Override
    public TestAction http(BuilderSupport<HttpActionBuilder> configurer) {
        HttpActionBuilder builder = new HttpActionBuilder().withApplicationContext(this.applicationContext);
        configurer.configure(builder);
        return ((DelegatingTestAction)((Object)this.run(builder.build()))).getDelegate();
    }

    @Override
    public TestAction soap(BuilderSupport<SoapActionBuilder> configurer) {
        SoapActionBuilder builder = new SoapActionBuilder().withApplicationContext(this.applicationContext);
        configurer.configure(builder);
        return ((DelegatingTestAction)((Object)this.run(builder.build()))).getDelegate();
    }

    @Override
    public TestAction camel(BuilderSupport<CamelRouteActionBuilder> configurer) {
        CamelRouteActionBuilder builder = new CamelRouteActionBuilder().withApplicationContext(this.applicationContext);
        configurer.configure(builder);
        return ((DelegatingTestAction)((Object)this.run(builder.build()))).getDelegate();
    }

    @Override
    public TestAction zookeeper(BuilderSupport<ZooActionBuilder> configurer) {
        ZooActionBuilder builder = new ZooActionBuilder().withApplicationContext(this.applicationContext);
        configurer.configure(builder);
        return this.run(builder.build());
    }

    @Override
    public Template applyTemplate(BuilderSupport<TemplateBuilder> configurer) {
        TemplateBuilder builder = new TemplateBuilder();
        configurer.configure(builder);
        builder.load(this.applicationContext);
        configurer.configure(builder);
        return (Template)this.run(builder.build());
    }

    @Override
    public FinallySequenceBuilder doFinally() {
        FinallySequenceBuilder builder = new FinallySequenceBuilder(this);
        this.containers.push((AbstractActionContainer)builder.build());
        return builder;
    }

    public TestContext getTestContext() {
        return this.context;
    }

    public void setTestContext(TestContext context) {
        this.context = context;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public TestCase getTestCase() {
        return this.testCase;
    }
}

