/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.junit;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.design.DefaultTestDesigner;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.dsl.runner.DefaultTestRunner;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.junit.AbstractJUnit4CitrusTest;
import com.consol.citrus.junit.CitrusJUnit4Runner;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class JUnit4CitrusTest
extends AbstractJUnit4CitrusTest {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DESIGNER_ATTRIBUTE = "designer";
    private static final String RUNNER_ATTRIBUTE = "runner";

    protected void run(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod) {
        TestDesigner testDesigner = null;
        TestRunner testRunner = null;
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance((ApplicationContext)this.applicationContext);
        }
        TestContext ctx = this.prepareTestContext(this.citrus.createTestContext());
        if (this.isDesignerMethod(frameworkMethod.getMethod())) {
            testDesigner = this.createTestDesigner(frameworkMethod, ctx);
        } else if (this.isRunnerMethod(frameworkMethod.getMethod())) {
            testRunner = this.createTestRunner(frameworkMethod, ctx);
        } else {
            throw new CitrusRuntimeException("Missing designer or runner method parameter");
        }
        TestCase testCase = testDesigner != null ? testDesigner.getTestCase() : testRunner.getTestCase();
        CitrusAnnotations.injectAll((Object)((Object)this), (Citrus)this.citrus, (TestContext)ctx);
        this.invokeTestMethod(frameworkMethod, testCase, ctx);
    }

    protected void invokeTestMethod(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod, TestCase testCase, TestContext context) {
        if (frameworkMethod.getAttribute(DESIGNER_ATTRIBUTE) != null) {
            try {
                ReflectionUtils.invokeMethod((Method)frameworkMethod.getMethod(), (Object)((Object)this), (Object[])this.resolveParameter(frameworkMethod, testCase, context));
                this.citrus.run((TestAction)testCase, context);
            }
            catch (TestCaseFailedException e) {
                throw e;
            }
            catch (AssertionError | Exception e) {
                testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
                testCase.finish(context);
                throw new TestCaseFailedException((Throwable)e);
            }
        }
        if (frameworkMethod.getAttribute(RUNNER_ATTRIBUTE) != null) {
            TestRunner testRunner = (TestRunner)frameworkMethod.getAttribute(RUNNER_ATTRIBUTE);
            try {
                Object[] params = this.resolveParameter(frameworkMethod, testCase, context);
                testRunner.start();
                ReflectionUtils.invokeMethod((Method)frameworkMethod.getMethod(), (Object)((Object)this), (Object[])params);
            }
            catch (AssertionError | Exception e) {
                testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
                throw new TestCaseFailedException((Throwable)e);
            }
            finally {
                testRunner.stop();
            }
        }
    }

    protected Object resolveAnnotatedResource(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod, Class<?> parameterType, TestContext context) {
        if (TestDesigner.class.isAssignableFrom(parameterType)) {
            return frameworkMethod.getAttribute(DESIGNER_ATTRIBUTE);
        }
        if (TestRunner.class.isAssignableFrom(parameterType)) {
            return frameworkMethod.getAttribute(RUNNER_ATTRIBUTE);
        }
        return super.resolveAnnotatedResource(frameworkMethod, parameterType, context);
    }

    protected TestDesigner createTestDesigner(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod, TestContext context) {
        DefaultTestDesigner testDesigner = new DefaultTestDesigner(this.applicationContext, context);
        testDesigner.testClass(((Object)((Object)this)).getClass());
        testDesigner.name(frameworkMethod.getTestName());
        testDesigner.packageName(frameworkMethod.getPackageName());
        frameworkMethod.setAttribute(DESIGNER_ATTRIBUTE, (Object)testDesigner);
        return testDesigner;
    }

    protected TestRunner createTestRunner(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod, TestContext context) {
        DefaultTestRunner testRunner = new DefaultTestRunner(this.applicationContext, context);
        testRunner.testClass(((Object)((Object)this)).getClass());
        testRunner.name(frameworkMethod.getTestName());
        testRunner.packageName(frameworkMethod.getPackageName());
        frameworkMethod.setAttribute(RUNNER_ATTRIBUTE, (Object)testRunner);
        return testRunner;
    }

    protected boolean isDesignerMethod(Method method) {
        Class<?>[] parameterTypes;
        for (Class<TestDesigner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestDesigner.class)) continue;
            return true;
        }
        return false;
    }

    protected boolean isRunnerMethod(Method method) {
        Class<?>[] parameterTypes;
        for (Class<TestRunner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestRunner.class)) continue;
            return true;
        }
        return false;
    }
}

