/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.kubernetes.actions.KubernetesExecuteAction;
import com.consol.citrus.kubernetes.client.KubernetesClient;
import com.consol.citrus.kubernetes.command.CommandResultCallback;
import com.consol.citrus.kubernetes.command.CreatePod;
import com.consol.citrus.kubernetes.command.CreateService;
import com.consol.citrus.kubernetes.command.DeletePod;
import com.consol.citrus.kubernetes.command.DeleteResult;
import com.consol.citrus.kubernetes.command.DeleteService;
import com.consol.citrus.kubernetes.command.GetPod;
import com.consol.citrus.kubernetes.command.GetService;
import com.consol.citrus.kubernetes.command.Info;
import com.consol.citrus.kubernetes.command.InfoResult;
import com.consol.citrus.kubernetes.command.KubernetesCommand;
import com.consol.citrus.kubernetes.command.ListEndpoints;
import com.consol.citrus.kubernetes.command.ListEvents;
import com.consol.citrus.kubernetes.command.ListNamespaces;
import com.consol.citrus.kubernetes.command.ListNodes;
import com.consol.citrus.kubernetes.command.ListPods;
import com.consol.citrus.kubernetes.command.ListReplicationControllers;
import com.consol.citrus.kubernetes.command.ListServices;
import com.consol.citrus.kubernetes.command.WatchNamespaces;
import com.consol.citrus.kubernetes.command.WatchNodes;
import com.consol.citrus.kubernetes.command.WatchPods;
import com.consol.citrus.kubernetes.command.WatchReplicationControllers;
import com.consol.citrus.kubernetes.command.WatchServices;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import org.springframework.core.io.Resource;

public class KubernetesActionBuilder
extends AbstractTestActionBuilder<KubernetesExecuteAction> {
    public KubernetesActionBuilder(KubernetesExecuteAction action) {
        super(action);
    }

    public KubernetesActionBuilder() {
        super(new KubernetesExecuteAction());
    }

    public KubernetesActionBuilder client(KubernetesClient kubernetesClient) {
        ((KubernetesExecuteAction)this.action).setKubernetesClient(kubernetesClient);
        return this;
    }

    public <T extends KubernetesCommand> T command(T command) {
        ((KubernetesExecuteAction)this.action).setCommand(command);
        return command;
    }

    public BaseActionBuilder<BaseActionBuilder, InfoResult> info() {
        return new BaseActionBuilder<BaseActionBuilder, InfoResult>((KubernetesCommand<InfoResult>)new Info());
    }

    public PodsActionBuilder pods() {
        return new PodsActionBuilder();
    }

    public ServicesActionBuilder services() {
        return new ServicesActionBuilder();
    }

    public ReplicationControllersActionBuilder replicationControllers() {
        return new ReplicationControllersActionBuilder();
    }

    public EndpointsActionBuilder endpoints() {
        return new EndpointsActionBuilder();
    }

    public NodesActionBuilder nodes() {
        return new NodesActionBuilder();
    }

    public EventsActionBuilder events() {
        return new EventsActionBuilder();
    }

    public NamespacesActionBuilder namespaces() {
        return new NamespacesActionBuilder();
    }

    public class ReplicationControllersActionBuilder {
        public NamespacedActionBuilder<ReplicationControllerList> list() {
            return new NamespacedActionBuilder<ReplicationControllerList>((KubernetesCommand<ReplicationControllerList>)new ListReplicationControllers());
        }

        public NamespacedActionBuilder<ReplicationController> watch() {
            return new NamespacedActionBuilder<ReplicationController>((KubernetesCommand<ReplicationController>)new WatchReplicationControllers());
        }
    }

    public class EventsActionBuilder {
        public NamespacedActionBuilder<EventList> list() {
            return new NamespacedActionBuilder<EventList>((KubernetesCommand<EventList>)new ListEvents());
        }
    }

    public class NamespacesActionBuilder {
        public BaseActionBuilder<BaseActionBuilder, NamespaceList> list() {
            return new BaseActionBuilder<BaseActionBuilder, NamespaceList>((KubernetesCommand<NamespaceList>)new ListNamespaces());
        }

        public BaseActionBuilder<BaseActionBuilder, Namespace> watch() {
            return new BaseActionBuilder<BaseActionBuilder, Namespace>((KubernetesCommand<Namespace>)new WatchNamespaces());
        }
    }

    public class NodesActionBuilder {
        public BaseActionBuilder<BaseActionBuilder, NodeList> list() {
            return new BaseActionBuilder<BaseActionBuilder, NodeList>((KubernetesCommand<NodeList>)new ListNodes());
        }

        public BaseActionBuilder<BaseActionBuilder, Node> watch() {
            return new BaseActionBuilder<BaseActionBuilder, Node>((KubernetesCommand<Node>)new WatchNodes());
        }
    }

    public class EndpointsActionBuilder {
        public NamespacedActionBuilder<EndpointsList> list() {
            return new NamespacedActionBuilder<EndpointsList>((KubernetesCommand<EndpointsList>)new ListEndpoints());
        }
    }

    public class ServicesActionBuilder {
        public NamespacedActionBuilder<ServiceList> list() {
            return new NamespacedActionBuilder<ServiceList>((KubernetesCommand<ServiceList>)new ListServices());
        }

        public NamedActionBuilder<Service> create(Service pod) {
            CreateService command = new CreateService();
            command.setService(pod);
            return new NamedActionBuilder<Service>((KubernetesCommand<Service>)command);
        }

        public NamedActionBuilder<Service> create(Resource template) {
            CreateService command = new CreateService();
            command.setTemplateResource(template);
            return new NamedActionBuilder<Service>((KubernetesCommand<Service>)command);
        }

        public NamedActionBuilder<Service> create(String templatePath) {
            CreateService command = new CreateService();
            command.setTemplate(templatePath);
            return new NamedActionBuilder<Service>((KubernetesCommand<Service>)command);
        }

        public NamedActionBuilder<Service> get(String name) {
            GetService command = new GetService();
            command.name(name);
            return new NamedActionBuilder<Service>((KubernetesCommand<Service>)command);
        }

        public NamedActionBuilder<DeleteResult> delete(String name) {
            DeleteService command = new DeleteService();
            command.name(name);
            return new NamedActionBuilder<DeleteResult>((KubernetesCommand<DeleteResult>)command);
        }

        public NamedActionBuilder<Service> watch() {
            return new NamedActionBuilder<Service>((KubernetesCommand<Service>)new WatchServices());
        }
    }

    public class PodsActionBuilder {
        public NamespacedActionBuilder<PodList> list() {
            ListPods command = new ListPods();
            return new NamespacedActionBuilder<PodList>((KubernetesCommand<PodList>)command);
        }

        public NamedActionBuilder<Pod> create(Pod pod) {
            CreatePod command = new CreatePod();
            command.setPod(pod);
            return new NamedActionBuilder<Pod>((KubernetesCommand<Pod>)command);
        }

        public NamedActionBuilder<Pod> create(Resource template) {
            CreatePod command = new CreatePod();
            command.setTemplateResource(template);
            return new NamedActionBuilder<Pod>((KubernetesCommand<Pod>)command);
        }

        public NamedActionBuilder<Pod> create(String templatePath) {
            CreatePod command = new CreatePod();
            command.setTemplate(templatePath);
            return new NamedActionBuilder<Pod>((KubernetesCommand<Pod>)command);
        }

        public NamedActionBuilder<Pod> get(String name) {
            GetPod command = new GetPod();
            command.name(name);
            return new NamedActionBuilder<Pod>((KubernetesCommand<Pod>)command);
        }

        public NamedActionBuilder<DeleteResult> delete(String name) {
            DeletePod command = new DeletePod();
            command.name(name);
            return new NamedActionBuilder<DeleteResult>((KubernetesCommand<DeleteResult>)command);
        }

        public NamedActionBuilder<Pod> watch() {
            return new NamedActionBuilder<Pod>((KubernetesCommand<Pod>)new WatchPods());
        }
    }

    public class BaseActionBuilder<T extends BaseActionBuilder, R extends KubernetesResource>
    extends AbstractTestActionBuilder<KubernetesExecuteAction> {
        protected final KubernetesCommand<R> command;
        protected T self;

        BaseActionBuilder(KubernetesCommand<R> command) {
            super(KubernetesActionBuilder.this.action);
            this.self = this;
            this.command = command;
            this.command(command);
        }

        public T result(String result) {
            ((KubernetesExecuteAction)this.action).setCommandResult(result);
            return this.self;
        }

        public T validate(String path, Object value) {
            ((KubernetesExecuteAction)this.action).getCommandResultExpressions().put(path, value);
            return this.self;
        }

        public T validate(CommandResultCallback<R> callback) {
            this.command.validate(callback);
            return this.self;
        }

        public T label(String key, String value) {
            this.command.label(key, value);
            return this.self;
        }

        public T label(String key) {
            this.command.label(key);
            return this.self;
        }

        public T withoutLabel(String key, String value) {
            this.command.withoutLabel(key, value);
            return this.self;
        }

        public T withoutLabel(String key) {
            this.command.withoutLabel(key);
            return this.self;
        }

        protected T command(KubernetesCommand<R> command) {
            KubernetesActionBuilder.this.command(command);
            return this.self;
        }
    }

    public class NamedActionBuilder<R extends KubernetesResource>
    extends BaseActionBuilder<NamedActionBuilder<R>, R> {
        NamedActionBuilder(KubernetesCommand<R> command) {
            super(command);
        }

        public NamedActionBuilder<R> name(String key) {
            this.command.name(key);
            return this;
        }

        public NamedActionBuilder<R> namespace(String key) {
            this.command.namespace(key);
            return this;
        }
    }

    public class NamespacedActionBuilder<R extends KubernetesResource>
    extends BaseActionBuilder<NamespacedActionBuilder<R>, R> {
        NamespacedActionBuilder(KubernetesCommand<R> command) {
            super(command);
        }

        public NamespacedActionBuilder<R> namespace(String key) {
            this.command.namespace(key);
            return this;
        }
    }
}

