/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.HttpClientActionBuilder;
import com.consol.citrus.dsl.builder.HttpServerActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.client.HttpClient;
import com.consol.citrus.http.server.HttpServer;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class HttpActionBuilder
extends AbstractTestActionBuilder<DelegatingTestAction<TestAction>> {
    private ApplicationContext applicationContext;

    public HttpActionBuilder() {
        super(new DelegatingTestAction());
    }

    public HttpClientActionBuilder client(HttpClient httpClient) {
        HttpClientActionBuilder clientAction = new HttpClientActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)this.action), (Endpoint)httpClient).withApplicationContext(this.applicationContext);
        return clientAction;
    }

    public HttpClientActionBuilder client(String httpClient) {
        HttpClientActionBuilder clientAction = new HttpClientActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)this.action), httpClient).withApplicationContext(this.applicationContext);
        return clientAction;
    }

    public HttpServerActionBuilder server(HttpServer httpServer) {
        HttpServerActionBuilder serverAction = new HttpServerActionBuilder((DelegatingTestAction)this.action, (Endpoint)httpServer).withApplicationContext(this.applicationContext);
        return serverAction;
    }

    public HttpServerActionBuilder server(String httpServer) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        HttpServerActionBuilder serverAction = new HttpServerActionBuilder((DelegatingTestAction)this.action, (Endpoint)this.applicationContext.getBean(httpServer, Endpoint.class)).withApplicationContext(this.applicationContext);
        return serverAction;
    }

    public HttpActionBuilder withApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }
}

