/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.actions.ExecutePLSQLAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class ExecutePLSQLBuilder
extends AbstractTestActionBuilder<ExecutePLSQLAction> {
    public ExecutePLSQLBuilder(ExecutePLSQLAction action) {
        super(action);
    }

    public ExecutePLSQLBuilder() {
        super(new ExecutePLSQLAction());
    }

    public ExecutePLSQLBuilder jdbcTemplate(JdbcTemplate jdbcTemplate) {
        ((ExecutePLSQLAction)this.action).setJdbcTemplate(jdbcTemplate);
        return this;
    }

    public ExecutePLSQLBuilder transactionManager(PlatformTransactionManager transactionManager) {
        ((ExecutePLSQLAction)this.action).setTransactionManager(transactionManager);
        return this;
    }

    public ExecutePLSQLBuilder transactionTimeout(int transactionTimeout) {
        ((ExecutePLSQLAction)this.action).setTransactionTimeout(String.valueOf(transactionTimeout));
        return this;
    }

    public ExecutePLSQLBuilder transactionTimeout(String transactionTimeout) {
        ((ExecutePLSQLAction)this.action).setTransactionTimeout(transactionTimeout);
        return this;
    }

    public ExecutePLSQLBuilder transactionIsolationLevel(String isolationLevel) {
        ((ExecutePLSQLAction)this.action).setTransactionIsolationLevel(isolationLevel);
        return this;
    }

    public ExecutePLSQLBuilder dataSource(DataSource dataSource) {
        ((ExecutePLSQLAction)this.action).setDataSource(dataSource);
        return this;
    }

    public ExecutePLSQLBuilder statements(List<String> statements) {
        ((ExecutePLSQLAction)this.action).getStatements().addAll(statements);
        return this;
    }

    public ExecutePLSQLBuilder statement(String sql) {
        ((ExecutePLSQLAction)this.action).getStatements().add(sql);
        return this;
    }

    public ExecutePLSQLBuilder sqlResource(String filePath) {
        ((ExecutePLSQLAction)this.action).setSqlResourcePath(filePath);
        return this;
    }

    public ExecutePLSQLBuilder sqlResource(Resource sqlResource) {
        return this.sqlResource(sqlResource, FileUtils.getDefaultCharset());
    }

    public ExecutePLSQLBuilder sqlResource(Resource sqlResource, Charset charset) {
        try {
            ((ExecutePLSQLAction)this.action).setScript(FileUtils.readToString((Resource)sqlResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read sql resource", (Throwable)e);
        }
        return this;
    }

    public ExecutePLSQLBuilder sqlScript(String script) {
        ((ExecutePLSQLAction)this.action).setScript(script);
        return this;
    }

    public ExecutePLSQLBuilder ignoreErrors(boolean ignoreErrors) {
        ((ExecutePLSQLAction)this.action).setIgnoreErrors(ignoreErrors);
        return this;
    }
}

