/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.camel.actions.AbstractCamelRouteAction;
import com.consol.citrus.camel.actions.CamelControlBusAction;
import com.consol.citrus.camel.actions.CreateCamelRouteAction;
import com.consol.citrus.camel.actions.RemoveCamelRouteAction;
import com.consol.citrus.camel.actions.StartCamelRouteAction;
import com.consol.citrus.camel.actions.StopCamelRouteAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.CamelControlBusActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ModelCamelContext;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class CamelRouteActionBuilder
extends AbstractTestActionBuilder<DelegatingTestAction<AbstractCamelRouteAction>> {
    private ModelCamelContext camelContext;
    private ApplicationContext applicationContext;

    public CamelRouteActionBuilder() {
        super(new DelegatingTestAction());
    }

    public CamelRouteActionBuilder context(String camelContext) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        this.camelContext = (ModelCamelContext)this.applicationContext.getBean(camelContext, ModelCamelContext.class);
        return this;
    }

    public CamelRouteActionBuilder context(ModelCamelContext camelContext) {
        this.camelContext = camelContext;
        return this;
    }

    public CamelControlBusActionBuilder controlBus() {
        CamelControlBusAction camelControlBusAction = new CamelControlBusAction();
        camelControlBusAction.setCamelContext((CamelContext)this.getCamelContext());
        ((DelegatingTestAction)this.action).setDelegate(camelControlBusAction);
        return new CamelControlBusActionBuilder(camelControlBusAction);
    }

    public CamelRouteActionBuilder create(RouteBuilder routeBuilder) {
        CreateCamelRouteAction camelRouteAction = new CreateCamelRouteAction();
        try {
            if (!routeBuilder.getContext().equals(this.getCamelContext())) {
                routeBuilder.configureRoutes(this.getCamelContext());
            } else {
                routeBuilder.configure();
            }
            camelRouteAction.setRoutes(routeBuilder.getRouteCollection().getRoutes());
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to configure route definitions with camel context", (Throwable)e);
        }
        camelRouteAction.setCamelContext((CamelContext)this.getCamelContext());
        ((DelegatingTestAction)this.action).setDelegate(camelRouteAction);
        return this;
    }

    public void start(String ... routes) {
        StartCamelRouteAction camelRouteAction = new StartCamelRouteAction();
        camelRouteAction.setRouteIds(Arrays.asList(routes));
        camelRouteAction.setCamelContext((CamelContext)this.getCamelContext());
        ((DelegatingTestAction)this.action).setDelegate(camelRouteAction);
    }

    public void stop(String ... routes) {
        StopCamelRouteAction camelRouteAction = new StopCamelRouteAction();
        camelRouteAction.setRouteIds(Arrays.asList(routes));
        camelRouteAction.setCamelContext((CamelContext)this.getCamelContext());
        ((DelegatingTestAction)this.action).setDelegate(camelRouteAction);
    }

    public void remove(String ... routes) {
        RemoveCamelRouteAction camelRouteAction = new RemoveCamelRouteAction();
        camelRouteAction.setRouteIds(Arrays.asList(routes));
        camelRouteAction.setCamelContext((CamelContext)this.getCamelContext());
        ((DelegatingTestAction)this.action).setDelegate(camelRouteAction);
    }

    public CamelRouteActionBuilder withApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    private ModelCamelContext getCamelContext() {
        if (this.camelContext == null) {
            Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
            this.camelContext = this.applicationContext.containsBean("citrusCamelContext") ? (ModelCamelContext)this.applicationContext.getBean("citrusCamelContext", ModelCamelContext.class) : (ModelCamelContext)this.applicationContext.getBean(ModelCamelContext.class);
        }
        return this.camelContext;
    }
}

