/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.xpath;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.xml.xpath.XPathExpressionResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XPathUtils {
    private static Logger log = LoggerFactory.getLogger(XPathUtils.class);
    public static final String DYNAMIC_NS_START = "{";
    public static final String DYNAMIC_NS_END = "}";
    private static final String DYNAMIC_NS_PREFIX = "dns";

    private XPathUtils() {
    }

    public static Map<String, String> getDynamicNamespaces(String expression) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        if (expression.contains(DYNAMIC_NS_START) && expression.contains(DYNAMIC_NS_END)) {
            String[] tokens = expression.split("\\{");
            for (int i = 1; i < tokens.length; ++i) {
                String namespace = tokens[i].substring(0, tokens[i].indexOf(DYNAMIC_NS_END));
                if (namespaces.containsValue(namespace)) continue;
                namespaces.put(DYNAMIC_NS_PREFIX + i, namespace);
            }
        }
        return namespaces;
    }

    public static String replaceDynamicNamespaces(String expression, Map<String, String> namespaces) {
        String expressionResult = expression;
        for (Map.Entry<String, String> namespaceEntry : namespaces.entrySet()) {
            if (!expressionResult.contains(DYNAMIC_NS_START + namespaceEntry.getValue() + DYNAMIC_NS_END)) continue;
            expressionResult = expressionResult.replaceAll("\\{" + namespaceEntry.getValue().replace(".", "\\.") + "\\" + DYNAMIC_NS_END, namespaceEntry.getKey() + ":");
        }
        return expressionResult;
    }

    public static boolean hasDynamicNamespaces(String expression) {
        return expression.contains(DYNAMIC_NS_START) && expression.contains(DYNAMIC_NS_END);
    }

    public static Object evaluate(Node node, String xPathExpression, NamespaceContext nsContext, XPathExpressionResult resultType) {
        if (resultType.equals((Object)XPathExpressionResult.NODE)) {
            Node resultNode = XPathUtils.evaluateAsNode(node, xPathExpression, nsContext);
            if (resultNode.getNodeType() == 1) {
                if (resultNode.getFirstChild() != null) {
                    return resultNode.getFirstChild().getNodeValue();
                }
                return "";
            }
            return resultNode.getNodeValue();
        }
        if (resultType.equals((Object)XPathExpressionResult.NODESET)) {
            NodeList resultNodeList = XPathUtils.evaluateAsNodeList(node, xPathExpression, nsContext);
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < resultNodeList.getLength(); ++i) {
                Node resultNode = resultNodeList.item(i);
                if (resultNode.getNodeType() == 1) {
                    if (resultNode.getFirstChild() != null) {
                        values.add(resultNode.getFirstChild().getNodeValue());
                        continue;
                    }
                    values.add("");
                    continue;
                }
                values.add(resultNode.getNodeValue());
            }
            return values;
        }
        if (resultType.equals((Object)XPathExpressionResult.STRING)) {
            return XPathUtils.evaluateAsString(node, xPathExpression, nsContext);
        }
        Object result = XPathUtils.evaluateAsObject(node, xPathExpression, nsContext, resultType.getAsQName());
        if (result == null) {
            throw new CitrusRuntimeException("No result for XPath expression: '" + xPathExpression + "'");
        }
        if (resultType.equals((Object)XPathExpressionResult.INTEGER)) {
            return (int)Math.round((Double)result);
        }
        return result;
    }

    public static Node evaluateAsNode(Node node, String xPathExpression, NamespaceContext nsContext) {
        Node result = (Node)XPathUtils.evaluateExpression(node, xPathExpression, nsContext, XPathConstants.NODE);
        if (result == null) {
            throw new CitrusRuntimeException("No result for XPath expression: '" + xPathExpression + "'");
        }
        return result;
    }

    public static NodeList evaluateAsNodeList(Node node, String xPathExpression, NamespaceContext nsContext) {
        NodeList result = (NodeList)XPathUtils.evaluateExpression(node, xPathExpression, nsContext, XPathConstants.NODESET);
        if (result == null) {
            throw new CitrusRuntimeException("No result for XPath expression: '" + xPathExpression + "'");
        }
        return result;
    }

    public static String evaluateAsString(Node node, String xPathExpression, NamespaceContext nsContext) {
        String result = (String)XPathUtils.evaluateExpression(node, xPathExpression, nsContext, XPathConstants.STRING);
        if (!StringUtils.hasText((String)result)) {
            XPathUtils.evaluateAsNode(node, xPathExpression, nsContext);
        }
        return result;
    }

    public static Boolean evaluateAsBoolean(Node node, String xPathExpression, NamespaceContext nsContext) {
        return (Boolean)XPathUtils.evaluateExpression(node, xPathExpression, nsContext, XPathConstants.BOOLEAN);
    }

    public static Double evaluateAsNumber(Node node, String xPathExpression, NamespaceContext nsContext) {
        return (Double)XPathUtils.evaluateExpression(node, xPathExpression, nsContext, XPathConstants.NUMBER);
    }

    public static Object evaluateAsObject(Node node, String xPathExpression, NamespaceContext nsContext, QName resultType) {
        return XPathUtils.evaluateExpression(node, xPathExpression, nsContext, resultType);
    }

    private static XPathExpression buildExpression(String xPathExpression, NamespaceContext nsContext) throws XPathExpressionException {
        XPath xpath = XPathUtils.createXPathFactory().newXPath();
        if (nsContext != null) {
            xpath.setNamespaceContext(nsContext);
        }
        return xpath.compile(xPathExpression);
    }

    public static boolean isXPathExpression(String expression) {
        return expression.indexOf(47) != -1 || expression.indexOf(40) != -1;
    }

    public static Object evaluateExpression(Node node, String xPathExpression, NamespaceContext nsContext, QName returnType) {
        try {
            return XPathUtils.buildExpression(xPathExpression, nsContext).evaluate(node, returnType);
        }
        catch (XPathExpressionException e) {
            throw new CitrusRuntimeException("Can not evaluate xpath expression '" + xPathExpression + "'", e);
        }
    }

    private static synchronized XPathFactory createXPathFactory() {
        XPathFactory factory = null;
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            String uri;
            String key = (String)prop.getKey();
            if (!key.startsWith("javax.xml.xpath.XPathFactory") || (uri = key.indexOf(":") > 0 ? key.substring(key.indexOf(":") + 1) : null) == null) continue;
            try {
                factory = XPathFactory.newInstance(uri);
            }
            catch (XPathFactoryConfigurationException e) {
                log.warn("Failed to instantiate xpath factory", (Throwable)e);
                factory = XPathFactory.newInstance();
            }
            log.info("Created xpath factory {} using system property {} with value {}", new Object[]{factory, key, uri});
        }
        if (factory == null) {
            factory = XPathFactory.newInstance();
            log.info("Created default xpath factory {}", (Object)factory);
        }
        return factory;
    }
}

