/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.schema.locator;

import java.io.IOException;
import java.net.URI;
import javax.wsdl.xml.WSDLLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.InputSource;

public class JarWSDLLocator
implements WSDLLocator {
    private static Logger log = LoggerFactory.getLogger(JarWSDLLocator.class);
    private Resource wsdl;
    private Resource importResource = null;

    public JarWSDLLocator(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public InputSource getBaseInputSource() {
        try {
            return new InputSource(this.wsdl.getInputStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        URI importURI = URI.create(importLocation);
        String resolvedImportLocation = importURI.isAbsolute() ? importLocation : parentLocation.substring(0, parentLocation.lastIndexOf(47) + 1) + importLocation;
        try {
            this.importResource = new PathMatchingResourcePatternResolver().getResource(resolvedImportLocation);
            return new InputSource(this.importResource.getInputStream());
        }
        catch (IOException e) {
            log.warn(String.format("Failed to resolve imported WSDL schema path location '%s'", importLocation), (Throwable)e);
            return null;
        }
    }

    public String getBaseURI() {
        try {
            return this.wsdl.getURI().toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getLatestImportURI() {
        if (this.importResource == null) {
            return null;
        }
        try {
            return this.importResource.getURI().toString();
        }
        catch (IOException e) {
            log.warn("Failed to resolve last imported WSDL schema resource", (Throwable)e);
            return null;
        }
    }

    public void close() {
    }
}

