/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.schema;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.xml.schema.AbstractSchemaCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class XsdSchemaCollection
extends AbstractSchemaCollection {
    protected List<String> schemas = new ArrayList<String>();

    @Override
    protected Resource loadSchemaResources() {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        for (String location : this.schemas) {
            try {
                Resource[] findings;
                for (Resource finding : findings = resourcePatternResolver.getResources(location)) {
                    if (!finding.getFilename().endsWith(".xsd") && !finding.getFilename().endsWith(".wsdl")) continue;
                    this.schemaResources.add(finding);
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read schema resources for location: " + location, e);
            }
        }
        return (Resource)this.schemaResources.get(0);
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }
}

