/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.schema;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.xml.schema.AbstractSchemaCollection;
import com.consol.citrus.xml.schema.locator.JarWSDLLocator;
import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;

public class WsdlXsdSchema
extends AbstractSchemaCollection {
    private Resource wsdl;
    private static Logger log = LoggerFactory.getLogger(WsdlXsdSchema.class);

    public WsdlXsdSchema() {
    }

    public WsdlXsdSchema(Resource wsdl) {
        this.wsdl = wsdl;
    }

    @Override
    public Resource loadSchemaResources() {
        Assert.notNull((Object)this.wsdl, (String)"wsdl file resource is required");
        Assert.isTrue((boolean)this.wsdl.exists(), (String)("wsdl file resource '" + this.wsdl + " does not exist"));
        try {
            return this.loadSchemas(this.getWsdlDefinition(this.wsdl));
        }
        catch (Exception e) {
            throw new BeanCreationException("Failed to load schema types from WSDL file", (Throwable)e);
        }
    }

    private Resource loadSchemas(Definition definition) throws WSDLException, IOException, TransformerException, TransformerFactoryConfigurationError {
        Types types = definition.getTypes();
        Resource targetXsd = null;
        Resource firstSchemaInWSDL = null;
        if (types != null) {
            List schemaTypes = types.getExtensibilityElements();
            for (Object schemaObject : schemaTypes) {
                if (schemaObject instanceof SchemaImpl) {
                    SchemaImpl schema = (SchemaImpl)schemaObject;
                    this.inheritNamespaces(schema, definition);
                    this.addImportedSchemas((Schema)schema);
                    this.addIncludedSchemas((Schema)schema);
                    if (this.importedSchemas.contains(this.getTargetNamespace((Schema)schema))) continue;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DOMSource source = new DOMSource(schema.getElement());
                    StreamResult result = new StreamResult(bos);
                    TransformerFactory.newInstance().newTransformer().transform(source, result);
                    ByteArrayResource schemaResource = new ByteArrayResource(bos.toByteArray());
                    this.importedSchemas.add(this.getTargetNamespace((Schema)schema));
                    this.schemaResources.add(schemaResource);
                    if (definition.getTargetNamespace().equals(this.getTargetNamespace((Schema)schema)) && targetXsd == null) {
                        targetXsd = schemaResource;
                        continue;
                    }
                    if (targetXsd != null || firstSchemaInWSDL != null) continue;
                    firstSchemaInWSDL = schemaResource;
                    continue;
                }
                log.warn("Found unsupported schema type implementation " + schemaObject.getClass());
            }
        }
        for (Object imports : definition.getImports().values()) {
            for (Import wsdlImport : (Vector)imports) {
                URI locationURI = URI.create(wsdlImport.getLocationURI());
                String schemaLocation = locationURI.isAbsolute() ? wsdlImport.getLocationURI() : definition.getDocumentBaseURI().substring(0, definition.getDocumentBaseURI().lastIndexOf(47) + 1) + wsdlImport.getLocationURI();
                this.loadSchemas(this.getWsdlDefinition((Resource)new FileSystemResource(schemaLocation)));
            }
        }
        if (targetXsd == null) {
            if (firstSchemaInWSDL != null) {
                targetXsd = firstSchemaInWSDL;
            } else if (!CollectionUtils.isEmpty((Collection)this.schemaResources)) {
                targetXsd = (Resource)this.schemaResources.get(0);
            }
        }
        return targetXsd;
    }

    private void inheritNamespaces(SchemaImpl schema, Definition wsdl) {
        Map wsdlNamespaces = wsdl.getNamespaces();
        for (Map.Entry nsEntry : wsdlNamespaces.entrySet()) {
            if (StringUtils.hasText((String)((String)nsEntry.getKey()))) {
                if (schema.getElement().hasAttributeNS("http://www.w3.org/2000/xmlns/", (String)nsEntry.getKey())) continue;
                schema.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)nsEntry.getKey(), (String)nsEntry.getValue());
                continue;
            }
            if (schema.getElement().hasAttribute("xmlns")) continue;
            schema.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns" + (String)nsEntry.getKey(), (String)nsEntry.getValue());
        }
    }

    private Definition getWsdlDefinition(Resource wsdl) {
        try {
            Definition definition = wsdl.getURI().toString().startsWith("jar:") ? WSDLFactory.newInstance().newWSDLReader().readWSDL((WSDLLocator)new JarWSDLLocator(wsdl)) : WSDLFactory.newInstance().newWSDLReader().readWSDL(wsdl.getURI().getPath(), new InputSource(wsdl.getInputStream()));
            return definition;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read wsdl file resource", e);
        }
        catch (WSDLException e) {
            throw new CitrusRuntimeException("Failed to wsdl schema instance", e);
        }
    }

    private String getTargetNamespace(Schema schema) {
        return schema.getElement().getAttribute("targetNamespace");
    }

    public void setWsdl(Resource wsdl) {
        this.wsdl = wsdl;
    }
}

