/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.namespace;

import com.consol.citrus.message.Message;
import com.consol.citrus.util.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.springframework.util.CollectionUtils;
import org.springframework.xml.namespace.SimpleNamespaceContext;

public class NamespaceContextBuilder {
    public static final String DEFAULT_BEAN_ID = "namespaceContextBuilder";
    private Map<String, String> namespaceMappings = new HashMap<String, String>();

    public NamespaceContext buildContext(Message receivedMessage, Map<String, String> namespaces) {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        if (this.namespaceMappings.size() > 0) {
            simpleNamespaceContext.setBindings(this.namespaceMappings);
        }
        Map<String, String> dynamicBindings = XMLUtils.lookupNamespaces(receivedMessage.getPayload(String.class));
        if (!CollectionUtils.isEmpty(namespaces)) {
            for (Map.Entry<String, String> binding : dynamicBindings.entrySet()) {
                if (namespaces.containsValue(binding.getValue())) continue;
                simpleNamespaceContext.bindNamespaceUri(binding.getKey(), binding.getValue());
            }
            simpleNamespaceContext.setBindings(namespaces);
        } else {
            simpleNamespaceContext.setBindings(dynamicBindings);
        }
        return simpleNamespaceContext;
    }

    public void setNamespaceMappings(Map<String, String> defaultMappings) {
        this.namespaceMappings = defaultMappings;
    }

    public Map<String, String> getNamespaceMappings() {
        return this.namespaceMappings;
    }
}

