/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml;

import com.consol.citrus.xml.schema.TargetNamespaceSchemaMappingStrategy;
import com.consol.citrus.xml.schema.WsdlXsdSchema;
import com.consol.citrus.xml.schema.XsdSchemaMappingStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.xml.xsd.SimpleXsdSchema;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XsdSchemaRepository
implements BeanNameAware,
InitializingBean {
    private String name = "schemaRepository";
    private List<XsdSchema> schemas = new ArrayList<XsdSchema>();
    private List<String> locations = new ArrayList<String>();
    private XsdSchemaMappingStrategy schemaMappingStrategy = new TargetNamespaceSchemaMappingStrategy();
    private static Logger log = LoggerFactory.getLogger(XsdSchemaRepository.class);

    public boolean canValidate(Document doc) {
        XsdSchema schema = this.schemaMappingStrategy.getSchema(this.schemas, doc);
        return schema != null;
    }

    public void afterPropertiesSet() throws Exception {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        for (String location : this.locations) {
            Resource[] findings;
            for (Resource resource : findings = resourcePatternResolver.getResources(location)) {
                this.addSchemas(resource);
            }
        }
        this.addCitrusSchema("citrus-http-message");
        this.addCitrusSchema("citrus-mail-message");
        this.addCitrusSchema("citrus-ftp-message");
        this.addCitrusSchema("citrus-jdbc-message");
        this.addCitrusSchema("citrus-ssh-message");
        this.addCitrusSchema("citrus-rmi-message");
        this.addCitrusSchema("citrus-jmx-message");
    }

    protected void addCitrusSchema(String schemaName) throws IOException, SAXException, ParserConfigurationException {
        Resource resource = new PathMatchingResourcePatternResolver().getResource("classpath:com/consol/citrus/schema/" + schemaName + ".xsd");
        if (resource.exists()) {
            this.addXsdSchema(resource);
        }
    }

    private void addSchemas(Resource resource) throws ParserConfigurationException, IOException, SAXException {
        if (resource.getFilename().endsWith(".xsd")) {
            this.addXsdSchema(resource);
        } else if (resource.getFilename().endsWith(".wsdl")) {
            this.addWsdlSchema(resource);
        } else {
            log.warn("Skipped resource other than XSD schema for repository (" + resource.getFilename() + ")");
        }
    }

    private void addWsdlSchema(Resource resource) throws ParserConfigurationException, IOException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Loading WSDL schema resource " + resource.getFilename());
        }
        WsdlXsdSchema wsdl = new WsdlXsdSchema(resource);
        wsdl.afterPropertiesSet();
        this.schemas.add((XsdSchema)wsdl);
    }

    private void addXsdSchema(Resource resource) throws ParserConfigurationException, IOException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Loading XSD schema resource " + resource.getFilename());
        }
        SimpleXsdSchema schema = new SimpleXsdSchema(resource);
        schema.afterPropertiesSet();
        this.schemas.add((XsdSchema)schema);
    }

    public List<XsdSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<XsdSchema> schemas) {
        this.schemas = schemas;
    }

    public void setSchemaMappingStrategy(XsdSchemaMappingStrategy schemaMappingStrategy) {
        this.schemaMappingStrategy = schemaMappingStrategy;
    }

    public XsdSchemaMappingStrategy getSchemaMappingStrategy() {
        return this.schemaMappingStrategy;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }
}

