/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.xml.LSResolverImpl;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSResourceResolver;
import org.w3c.dom.ls.LSSerializer;

public class XmlConfigurer
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(XmlConfigurer.class);
    private final DOMImplementationRegistry registry;
    private final DOMImplementationLS domImpl;
    private Map<String, Object> parseSettings = new HashMap<String, Object>();
    private Map<String, Object> serializeSettings = new HashMap<String, Object>();
    public static final String SPLIT_CDATA_SECTIONS = "split-cdata-sections";
    public static final String FORMAT_PRETTY_PRINT = "format-pretty-print";
    public static final String ELEMENT_CONTENT_WHITESPACE = "element-content-whitespace";
    public static final String CDATA_SECTIONS = "cdata-sections";
    public static final String VALIDATE_IF_SCHEMA = "validate-if-schema";
    public static final String RESOURCE_RESOLVER = "resource-resolver";
    public static final String XML_DECLARATION = "xml-declaration";

    public XmlConfigurer() {
        try {
            this.registry = DOMImplementationRegistry.newInstance();
            if (log.isDebugEnabled()) {
                DOMImplementationList domImplList = this.registry.getDOMImplementationList("LS");
                for (int i = 0; i < domImplList.getLength(); ++i) {
                    log.debug("Found DOMImplementationLS: " + domImplList.item(i));
                }
            }
            this.domImpl = (DOMImplementationLS)((Object)this.registry.getDOMImplementation("LS"));
            if (log.isDebugEnabled()) {
                log.debug("Using DOMImplementationLS: " + this.domImpl.getClass().getName());
            }
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(e);
        }
        this.setDefaultParseSettings();
        this.setDefaultSerializeSettings();
    }

    public LSParser createLSParser() {
        LSParser parser = this.domImpl.createLSParser((short)1, null);
        this.configureParser(parser);
        return parser;
    }

    protected void configureParser(LSParser parser) {
        for (Map.Entry<String, Object> setting : this.parseSettings.entrySet()) {
            this.setParserConfigParameter(parser, setting.getKey(), setting.getValue());
        }
    }

    public LSSerializer createLSSerializer() {
        LSSerializer serializer = this.domImpl.createLSSerializer();
        this.configureSerializer(serializer);
        return serializer;
    }

    protected void configureSerializer(LSSerializer serializer) {
        for (Map.Entry<String, Object> setting : this.serializeSettings.entrySet()) {
            this.setSerializerConfigParameter(serializer, setting.getKey(), setting.getValue());
        }
    }

    public LSInput createLSInput() {
        return this.domImpl.createLSInput();
    }

    public LSOutput createLSOutput() {
        return this.domImpl.createLSOutput();
    }

    public LSResourceResolver createLSResourceResolver() {
        return new LSResolverImpl(this.domImpl);
    }

    private void setDefaultParseSettings() {
        if (!this.parseSettings.containsKey(CDATA_SECTIONS)) {
            this.parseSettings.put(CDATA_SECTIONS, true);
        }
        if (!this.parseSettings.containsKey(SPLIT_CDATA_SECTIONS)) {
            this.parseSettings.put(SPLIT_CDATA_SECTIONS, false);
        }
        if (!this.parseSettings.containsKey(VALIDATE_IF_SCHEMA)) {
            this.parseSettings.put(VALIDATE_IF_SCHEMA, true);
        }
        if (!this.parseSettings.containsKey(RESOURCE_RESOLVER)) {
            this.parseSettings.put(RESOURCE_RESOLVER, this.createLSResourceResolver());
        }
        if (!this.parseSettings.containsKey(ELEMENT_CONTENT_WHITESPACE)) {
            this.parseSettings.put(ELEMENT_CONTENT_WHITESPACE, false);
        }
    }

    private void setDefaultSerializeSettings() {
        if (!this.serializeSettings.containsKey(ELEMENT_CONTENT_WHITESPACE)) {
            this.serializeSettings.put(ELEMENT_CONTENT_WHITESPACE, true);
        }
        if (!this.serializeSettings.containsKey(SPLIT_CDATA_SECTIONS)) {
            this.serializeSettings.put(SPLIT_CDATA_SECTIONS, false);
        }
        if (!this.serializeSettings.containsKey(FORMAT_PRETTY_PRINT)) {
            this.serializeSettings.put(FORMAT_PRETTY_PRINT, true);
        }
        if (!this.serializeSettings.containsKey(XML_DECLARATION)) {
            this.serializeSettings.put(XML_DECLARATION, true);
        }
    }

    public void setSerializerConfigParameter(LSSerializer serializer, String parameterName, Object value) {
        if (serializer.getDomConfig().canSetParameter(parameterName, value)) {
            serializer.getDomConfig().setParameter(parameterName, value);
        } else {
            this.logParameterNotSet(parameterName, "LSSerializer");
        }
    }

    public void setParserConfigParameter(LSParser parser, String parameterName, Object value) {
        if (parser.getDomConfig().canSetParameter(parameterName, value)) {
            parser.getDomConfig().setParameter(parameterName, value);
        } else {
            this.logParameterNotSet(parameterName, "LSParser");
        }
    }

    private void logParameterNotSet(String parameterName, String componentName) {
        log.warn("Unable to set '" + parameterName + "' parameter on " + componentName);
    }

    public void setParseSettings(Map<String, Object> parseSettings) {
        this.parseSettings = parseSettings;
    }

    public void setSerializeSettings(Map<String, Object> serializeSettings) {
        this.serializeSettings = serializeSettings;
    }

    public void afterPropertiesSet() throws Exception {
        this.setDefaultParseSettings();
        this.setDefaultSerializeSettings();
        XMLUtils.initialize(this);
    }
}

