/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable.dictionary.xml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.consol.citrus.variable.dictionary.xml.AbstractXmlDataDictionary;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import com.consol.citrus.xml.xpath.XPathUtils;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XpathMappingDataDictionary
extends AbstractXmlDataDictionary
implements InitializingBean {
    @Autowired(required=false)
    private NamespaceContextBuilder namespaceContextBuilder = new NamespaceContextBuilder();
    private static Logger log = LoggerFactory.getLogger(XpathMappingDataDictionary.class);

    @Override
    public <T> T translate(Node node, T value, TestContext context) {
        for (Map.Entry expressionEntry : this.mappings.entrySet()) {
            String expression = (String)expressionEntry.getKey();
            NodeList findings = (NodeList)XPathUtils.evaluateExpression(node.getOwnerDocument(), expression, this.buildNamespaceContext(node), XPathConstants.NODESET);
            if (findings == null || !this.containsNode(findings, node)) continue;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Data dictionary setting element '%s' value: %s", XMLUtils.getNodesPathName(node), expressionEntry.getValue()));
            }
            return this.convertIfNecessary(context.replaceDynamicContentInString((String)expressionEntry.getValue()), value);
        }
        return value;
    }

    private boolean containsNode(NodeList findings, Node node) {
        for (int i = 0; i < findings.getLength(); ++i) {
            if (!findings.item(i).equals(node)) continue;
            return true;
        }
        return false;
    }

    private NamespaceContext buildNamespaceContext(Node node) {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        Map<String, String> namespaces = XMLUtils.lookupNamespaces(node.getOwnerDocument());
        namespaces.putAll(this.namespaceContextBuilder.getNamespaceMappings());
        simpleNamespaceContext.setBindings(namespaces);
        return simpleNamespaceContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getPathMappingStrategy() != null && !this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.EXACT)) {
            log.warn(String.format("%s ignores path mapping strategy other than %s", new Object[]{this.getClass().getSimpleName(), DataDictionary.PathMappingStrategy.EXACT}));
        }
        super.afterPropertiesSet();
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.namespaceContextBuilder;
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }
}

