/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable.dictionary.xml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.consol.citrus.variable.dictionary.xml.AbstractXmlDataDictionary;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Node;

public class NodeMappingDataDictionary
extends AbstractXmlDataDictionary
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(NodeMappingDataDictionary.class);

    @Override
    public <T> T translate(Node node, T value, TestContext context) {
        block7: {
            String nodePath;
            block8: {
                block6: {
                    nodePath = XMLUtils.getNodesPathName(node);
                    if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.EXACT)) break block6;
                    if (this.mappings.containsKey(nodePath)) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Data dictionary setting element '%s' with value: %s", nodePath, this.mappings.get(nodePath)));
                        }
                        return this.convertIfNecessary(context.replaceDynamicContentInString((String)this.mappings.get(nodePath)), value);
                    }
                    break block7;
                }
                if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.ENDS_WITH)) break block8;
                for (Map.Entry entry : this.mappings.entrySet()) {
                    if (!nodePath.endsWith((String)entry.getKey())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Data dictionary setting element '%s' with value: %s", nodePath, entry.getValue()));
                    }
                    return this.convertIfNecessary(context.replaceDynamicContentInString((String)entry.getValue()), value);
                }
                break block7;
            }
            if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.STARTS_WITH)) break block7;
            for (Map.Entry entry : this.mappings.entrySet()) {
                if (!nodePath.startsWith((String)entry.getKey())) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Data dictionary setting element '%s' with value: %s", nodePath, entry.getValue()));
                }
                return this.convertIfNecessary(context.replaceDynamicContentInString((String)entry.getValue()), value);
            }
        }
        return value;
    }
}

