/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable.dictionary;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.TypeConversionUtils;
import com.consol.citrus.validation.interceptor.AbstractMessageConstructionInterceptor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public abstract class AbstractDataDictionary<T>
extends AbstractMessageConstructionInterceptor
implements DataDictionary<T>,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(AbstractDataDictionary.class);
    private String name = this.getClass().getSimpleName();
    private boolean globalScope = true;
    protected Map<String, String> mappings = new LinkedHashMap<String, String>();
    protected Resource mappingFile;
    private DataDictionary.PathMappingStrategy pathMappingStrategy = DataDictionary.PathMappingStrategy.EXACT;

    protected <T> T convertIfNecessary(String value, T originalValue) {
        if (originalValue == null) {
            return (T)value;
        }
        return (T)TypeConversionUtils.convertIfNecessary(value, originalValue.getClass());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mappingFile != null) {
            Properties props;
            if (log.isDebugEnabled()) {
                log.debug("Reading data dictionary mapping " + this.mappingFile.getFilename());
            }
            try {
                props = PropertiesLoaderUtils.loadProperties((Resource)this.mappingFile);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException(e);
            }
            Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().getKey().toString();
                if (log.isDebugEnabled()) {
                    log.debug("Loading data dictionary mapping: " + key + "=" + props.getProperty(key));
                }
                if (log.isDebugEnabled() && this.mappings.containsKey(key)) {
                    log.debug("Overwriting data dictionary mapping " + key + " old value:" + this.mappings.get(key) + " new value:" + props.getProperty(key));
                }
                this.mappings.put(key, props.getProperty(key));
            }
            log.debug("Loaded data dictionary mapping " + this.mappingFile.getFilename());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isGlobalScope() {
        return this.globalScope;
    }

    public void setGlobalScope(boolean scope) {
        this.globalScope = scope;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public Resource getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(Resource mappingFile) {
        this.mappingFile = mappingFile;
    }

    @Override
    public DataDictionary.PathMappingStrategy getPathMappingStrategy() {
        return this.pathMappingStrategy;
    }

    public void setPathMappingStrategy(DataDictionary.PathMappingStrategy pathMappingStrategy) {
        this.pathMappingStrategy = pathMappingStrategy;
    }
}

