/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.NoSuchVariableException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.springframework.util.StringUtils;

public final class VariableUtils {
    private VariableUtils() {
    }

    public static String getValueFromScript(String scriptEngine, String code) {
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName(scriptEngine);
            if (engine == null) {
                throw new CitrusRuntimeException("Unable to find script engine with name '" + scriptEngine + "'");
            }
            return engine.eval(code).toString();
        }
        catch (ScriptException e) {
            throw new CitrusRuntimeException("Failed to evaluate " + scriptEngine + " script", e);
        }
    }

    public static String cutOffSingleQuotes(String variable) {
        if (StringUtils.hasText((String)variable) && variable.length() > 1 && variable.charAt(0) == '\'' && variable.charAt(variable.length() - 1) == '\'') {
            return variable.substring(1, variable.length() - 1);
        }
        return variable;
    }

    public static String cutOffDoubleQuotes(String variable) {
        if (StringUtils.hasText((String)variable) && variable.length() > 1 && variable.charAt(0) == '\"' && variable.charAt(variable.length() - 1) == '\"') {
            return variable.substring(1, variable.length() - 1);
        }
        return variable;
    }

    public static String cutOffVariablesPrefix(String variable) {
        if (variable.startsWith("${") && variable.endsWith("}")) {
            return variable.substring("${".length(), variable.length() - "}".length());
        }
        return variable;
    }

    public static String cutOffVariablesEscaping(String variable) {
        if (variable.startsWith("//") && variable.endsWith("//")) {
            return variable.substring("//".length(), variable.length() - "//".length());
        }
        return variable;
    }

    public static boolean isVariableName(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return expression.startsWith("${") && expression.endsWith("}");
    }

    public static String replaceVariablesInString(String str, TestContext context, boolean enableQuoting) {
        int searchIndex;
        StringBuffer newStr = new StringBuffer();
        StringBuffer variableNameBuf = new StringBuffer();
        int startIndex = 0;
        while ((searchIndex = str.indexOf("${", startIndex)) != -1) {
            int curIndex;
            int control = 0;
            boolean isVarComplete = false;
            for (curIndex = searchIndex + "${".length(); curIndex < str.length() && !isVarComplete; ++curIndex) {
                if (str.indexOf("${", curIndex) == curIndex) {
                    ++control;
                }
                if (!Character.isJavaIdentifierPart(str.charAt(curIndex)) && str.charAt(curIndex) == "}".charAt(0) || curIndex + 1 == str.length()) {
                    if (control == 0) {
                        isVarComplete = true;
                    } else {
                        --control;
                    }
                }
                if (isVarComplete) continue;
                variableNameBuf.append(str.charAt(curIndex));
            }
            String value = context.getVariable(variableNameBuf.toString());
            if (value == null) {
                throw new NoSuchVariableException("Variable: " + variableNameBuf.toString() + " could not be found");
            }
            newStr.append(str.substring(startIndex, searchIndex));
            if (enableQuoting) {
                newStr.append("'" + value + "'");
            } else {
                newStr.append(value);
            }
            startIndex = curIndex;
            variableNameBuf = new StringBuffer();
            isVarComplete = false;
        }
        newStr.append(str.substring(startIndex));
        return newStr.toString();
    }
}

