/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.UnknownElementException;
import com.consol.citrus.message.Message;
import com.consol.citrus.variable.VariableExtractor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class MessageHeaderVariableExtractor
implements VariableExtractor {
    private Map<String, String> headerMappings = new HashMap<String, String>();

    @Override
    public void extractVariables(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.headerMappings)) {
            return;
        }
        for (Map.Entry<String, String> entry : this.headerMappings.entrySet()) {
            String headerElementName = entry.getKey();
            String targetVariableName = entry.getValue();
            if (message.getHeader(headerElementName) == null) {
                throw new UnknownElementException("Could not find header element " + headerElementName + " in received header");
            }
            context.setVariable(targetVariableName, message.getHeader(headerElementName).toString());
        }
    }

    public void setHeaderMappings(Map<String, String> headerMappings) {
        this.headerMappings = headerMappings;
    }

    public Map<String, String> getHeaderMappings() {
        return this.headerMappings;
    }
}

