/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.variable.GlobalVariables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class GlobalVariablesPropertyLoader
implements InitializingBean {
    public static final String BEAN_NAME = "globalVariablesPropertyLoader";
    @Autowired
    private GlobalVariables globalVariables;
    @Autowired
    private FunctionRegistry functionRegistry;
    private List<String> propertyFiles = new ArrayList<String>();
    private static Logger log = LoggerFactory.getLogger(GlobalVariablesPropertyLoader.class);

    public void loadPropertiesAsVariables() {
        BufferedReader reader = null;
        try {
            if (this.propertyFilesSet()) {
                for (String propertyFilePath : this.propertyFiles) {
                    String propertyExpression;
                    Resource propertyFile = new PathMatchingResourcePatternResolver().getResource(propertyFilePath.trim());
                    log.debug("Reading property file " + propertyFile.getFilename());
                    reader = new BufferedReader(new InputStreamReader(propertyFile.getInputStream()));
                    TestContext context = new TestContext();
                    context.setGlobalVariables(this.globalVariables);
                    context.setFunctionRegistry(this.functionRegistry);
                    while ((propertyExpression = reader.readLine()) != null) {
                        log.debug("Property line [ {} ]", (Object)propertyExpression);
                        propertyExpression = propertyExpression.trim();
                        if (!this.isPropertyLine(propertyExpression)) continue;
                        String key = propertyExpression.substring(0, propertyExpression.indexOf(61)).trim();
                        String value = propertyExpression.substring(propertyExpression.indexOf(61) + 1).trim();
                        log.debug("Property value replace dynamic content [ {} ]", (Object)value);
                        value = context.replaceDynamicContentInString(value);
                        if (log.isDebugEnabled()) {
                            log.debug("Loading property: " + key + "=" + value + " into default variables");
                        }
                        if (log.isDebugEnabled() && this.globalVariables.getVariables().containsKey(key)) {
                            log.debug("Overwriting property " + key + " old value:" + this.globalVariables.getVariables().get(key) + " new value:" + value);
                        }
                        this.globalVariables.getVariables().put(key, value);
                        context.setVariable(key, this.globalVariables.getVariables().get(key));
                    }
                    log.info("Loaded property file " + propertyFile.getFilename());
                }
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Error while loading property file", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close property file reader", (Throwable)e);
                }
            }
        }
    }

    private boolean propertyFilesSet() {
        return this.propertyFiles != null && this.propertyFiles.size() > 0;
    }

    private boolean isPropertyLine(String line) {
        return StringUtils.hasText((String)line) && !line.startsWith("#") && line.indexOf(61) > -1;
    }

    public void afterPropertiesSet() {
        this.loadPropertiesAsVariables();
    }

    public void setPropertyFiles(List<String> propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    public List<String> getPropertyFiles() {
        return this.propertyFiles;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public void setFunctionRegistry(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }
}

