/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.xml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.UnknownElementException;
import com.consol.citrus.message.Message;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.xml.xpath.XPathExpressionResult;
import com.consol.citrus.xml.xpath.XPathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XpathPayloadVariableExtractor
implements VariableExtractor {
    private Map<String, String> xPathExpressions = new HashMap<String, String>();
    private Map<String, String> namespaces = new HashMap<String, String>();
    private static Logger log = LoggerFactory.getLogger(XpathPayloadVariableExtractor.class);

    @Override
    public void extractVariables(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.xPathExpressions)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Reading XML elements with XPath");
        }
        NamespaceContext nsContext = context.getNamespaceContextBuilder().buildContext(message, this.namespaces);
        for (Map.Entry<String, String> entry : this.xPathExpressions.entrySet()) {
            String pathExpression = context.replaceDynamicContentInString(entry.getKey());
            String variableName = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug("Evaluating XPath expression: " + pathExpression);
            }
            Document doc = XMLUtils.parseMessagePayload(message.getPayload(String.class));
            if (XPathUtils.isXPathExpression(pathExpression)) {
                XPathExpressionResult resultType = XPathExpressionResult.fromString(pathExpression, XPathExpressionResult.STRING);
                Object value = XPathUtils.evaluate(doc, pathExpression = XPathExpressionResult.cutOffPrefix(pathExpression), nsContext, resultType);
                if (value == null) {
                    throw new CitrusRuntimeException("Not able to find value for expression: " + pathExpression);
                }
                if (value instanceof List) {
                    value = StringUtils.arrayToCommaDelimitedString((Object[])((List)value).toArray(new String[((List)value).size()]));
                }
                context.setVariable(variableName, value);
                continue;
            }
            Node node = XMLUtils.findNodeByName(doc, pathExpression);
            if (node == null) {
                throw new UnknownElementException("No element found for expression" + pathExpression);
            }
            if (node.getNodeType() == 1) {
                if (node.getFirstChild() != null) {
                    context.setVariable(this.xPathExpressions.get(pathExpression), node.getFirstChild().getNodeValue());
                    continue;
                }
                context.setVariable(this.xPathExpressions.get(pathExpression), "");
                continue;
            }
            context.setVariable(this.xPathExpressions.get(pathExpression), node.getNodeValue());
        }
    }

    public void setXpathExpressions(Map<String, String> xPathExpressions) {
        this.xPathExpressions = xPathExpressions;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public Map<String, String> getXpathExpressions() {
        return this.xPathExpressions;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }
}

