/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.xml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.UnknownElementException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.validation.AbstractMessageValidator;
import com.consol.citrus.validation.ValidationUtils;
import com.consol.citrus.validation.xml.DomXmlMessageValidator;
import com.consol.citrus.validation.xml.XmlValidationUtils;
import com.consol.citrus.validation.xml.XpathMessageValidationContext;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import com.consol.citrus.xml.xpath.XPathExpressionResult;
import com.consol.citrus.xml.xpath.XPathUtils;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XpathMessageValidator
extends AbstractMessageValidator<XpathMessageValidationContext> {
    private static Logger log = LoggerFactory.getLogger(XpathMessageValidator.class);
    @Autowired(required=false)
    private NamespaceContextBuilder namespaceContextBuilder = new NamespaceContextBuilder();

    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, XpathMessageValidationContext validationContext) throws ValidationException {
        if (CollectionUtils.isEmpty(validationContext.getXpathExpressions())) {
            return;
        }
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)receivedMessage.getPayload(String.class))) {
            throw new ValidationException("Unable to validate message elements - receive message payload was empty");
        }
        log.debug("Start XPath element validation ...");
        Document received = XMLUtils.parseMessagePayload(receivedMessage.getPayload(String.class));
        NamespaceContext namespaceContext = this.namespaceContextBuilder.buildContext(receivedMessage, validationContext.getNamespaces());
        for (Map.Entry<String, Object> entry : validationContext.getXpathExpressions().entrySet()) {
            Object xPathResult;
            String xPathExpression = entry.getKey();
            Object expectedValue = entry.getValue();
            if (XPathUtils.isXPathExpression(xPathExpression = context.replaceDynamicContentInString(xPathExpression))) {
                XPathExpressionResult resultType = XPathExpressionResult.fromString(xPathExpression, XPathExpressionResult.NODE);
                xPathExpression = XPathExpressionResult.cutOffPrefix(xPathExpression);
                if (resultType.equals((Object)XPathExpressionResult.NODE) && XmlValidationUtils.isElementIgnored(XPathUtils.evaluateAsNode(received, xPathExpression, namespaceContext), validationContext.getIgnoreExpressions(), namespaceContext)) continue;
                xPathResult = XPathUtils.evaluate(received, xPathExpression, namespaceContext, resultType);
            } else {
                Node node = XMLUtils.findNodeByName(received, xPathExpression);
                if (node == null) {
                    throw new UnknownElementException("Element ' " + xPathExpression + "' could not be found in DOM tree");
                }
                if (XmlValidationUtils.isElementIgnored(node, validationContext.getIgnoreExpressions(), namespaceContext)) continue;
                xPathResult = this.getNodeValue(node);
            }
            if (expectedValue instanceof String) {
                expectedValue = context.replaceDynamicContentInString(String.valueOf(expectedValue));
            }
            ValidationUtils.validateValues(xPathResult, expectedValue, xPathExpression, context);
            if (!log.isDebugEnabled()) continue;
            log.debug("Validating element: " + xPathExpression + "='" + expectedValue + "': OK.");
        }
        log.info("XPath element validation successful: All elements OK");
    }

    @Override
    protected Class<XpathMessageValidationContext> getRequiredValidationContextType() {
        return XpathMessageValidationContext.class;
    }

    @Override
    public boolean supportsMessageType(String messageType, Message message) {
        return new DomXmlMessageValidator().supportsMessageType(messageType, message);
    }

    private String getNodeValue(Node node) {
        if (node.getNodeType() == 1 && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return node.getNodeValue();
    }
}

