/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.xml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.UnknownElementException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.validation.interceptor.AbstractMessageConstructionInterceptor;
import com.consol.citrus.xml.xpath.XPathUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XpathMessageConstructionInterceptor
extends AbstractMessageConstructionInterceptor {
    private Map<String, String> xPathExpressions = new LinkedHashMap<String, String>();
    private static Logger log = LoggerFactory.getLogger(XpathMessageConstructionInterceptor.class);

    public XpathMessageConstructionInterceptor() {
    }

    public XpathMessageConstructionInterceptor(Map<String, String> xPathExpressions) {
        this.xPathExpressions.putAll(xPathExpressions);
    }

    @Override
    public Message interceptMessage(Message message, String messageType, TestContext context) {
        if (message.getPayload() == null || !StringUtils.hasText((String)message.getPayload(String.class))) {
            return message;
        }
        Document doc = XMLUtils.parseMessagePayload(message.getPayload(String.class));
        if (doc == null) {
            throw new CitrusRuntimeException("Not able to set message elements, because no XML ressource defined");
        }
        for (Map.Entry<String, String> entry : this.xPathExpressions.entrySet()) {
            String pathExpression = entry.getKey();
            String valueExpression = entry.getValue();
            valueExpression = context.replaceDynamicContentInString(valueExpression);
            Node node = XPathUtils.isXPathExpression(pathExpression) ? XPathUtils.evaluateAsNode(doc, pathExpression, context.getNamespaceContextBuilder().buildContext(message, Collections.emptyMap())) : XMLUtils.findNodeByName(doc, pathExpression);
            if (node == null) {
                throw new UnknownElementException("Could not find element for expression" + pathExpression);
            }
            if (node.getNodeType() == 1) {
                node.setTextContent(valueExpression);
            } else {
                node.setNodeValue(valueExpression);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Element " + pathExpression + " was set to value: " + valueExpression);
        }
        message.setPayload(XMLUtils.serialize(doc));
        return message;
    }

    @Override
    public boolean supportsMessageType(String messageType) {
        return MessageType.XML.toString().equalsIgnoreCase(messageType) || MessageType.XHTML.toString().equalsIgnoreCase(messageType);
    }

    public void setXPathExpressions(Map<String, String> xPathExpressions) {
        this.xPathExpressions = xPathExpressions;
    }

    public Map<String, String> getXPathExpressions() {
        return this.xPathExpressions;
    }
}

