/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.xml;

import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.xml.xpath.XPathUtils;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlValidationUtils {
    private static Logger log = LoggerFactory.getLogger(XmlValidationUtils.class);

    private XmlValidationUtils() {
    }

    public static boolean isElementIgnored(Node source, Node received, Set<String> ignoreExpressions, NamespaceContext namespaceContext) {
        if (XmlValidationUtils.isElementIgnored(received, ignoreExpressions, namespaceContext)) {
            if (log.isDebugEnabled()) {
                log.debug("Element: '" + received.getLocalName() + "' is on ignore list - skipped validation");
            }
            return true;
        }
        if (source.getFirstChild() != null && StringUtils.hasText((String)source.getFirstChild().getNodeValue()) && source.getFirstChild().getNodeValue().trim().equals("@ignore@")) {
            if (log.isDebugEnabled()) {
                log.debug("Element: '" + received.getLocalName() + "' is ignored by placeholder '" + "@ignore@" + "'");
            }
            return true;
        }
        return false;
    }

    public static boolean isElementIgnored(Node received, Set<String> ignoreExpressions, NamespaceContext namespaceContext) {
        if (CollectionUtils.isEmpty(ignoreExpressions)) {
            return false;
        }
        if (ignoreExpressions.contains(XMLUtils.getNodesPathName(received))) {
            return true;
        }
        for (String expression : ignoreExpressions) {
            if (received != XMLUtils.findNodeByName(received.getOwnerDocument(), expression)) continue;
            return true;
        }
        for (String expression : ignoreExpressions) {
            NodeList foundNodes;
            if (!XPathUtils.isXPathExpression(expression) || (foundNodes = XPathUtils.evaluateAsNodeList(received.getOwnerDocument(), expression, namespaceContext)) == null) continue;
            for (int i = 0; i < foundNodes.getLength(); ++i) {
                if (foundNodes.item(i) == null || !foundNodes.item(i).isSameNode(received)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAttributeIgnored(Node receivedElement, Node receivedAttribute, Node sourceAttribute, Set<String> ignoreMessageElements, NamespaceContext namespaceContext) {
        if (XmlValidationUtils.isAttributeIgnored(receivedElement, receivedAttribute, ignoreMessageElements, namespaceContext)) {
            if (log.isDebugEnabled()) {
                log.debug("Attribute '" + receivedAttribute.getLocalName() + "' is on ignore list - skipped value validation");
            }
            return true;
        }
        if (StringUtils.hasText((String)sourceAttribute.getNodeValue()) && sourceAttribute.getNodeValue().trim().equals("@ignore@")) {
            if (log.isDebugEnabled()) {
                log.debug("Attribute: '" + receivedAttribute.getLocalName() + "' is ignored by placeholder '" + "@ignore@" + "'");
            }
            return true;
        }
        return false;
    }

    private static boolean isAttributeIgnored(Node receivedElement, Node receivedAttribute, Set<String> ignoreMessageElements, NamespaceContext namespaceContext) {
        Node foundAttributeNode;
        if (CollectionUtils.isEmpty(ignoreMessageElements)) {
            return false;
        }
        if (ignoreMessageElements.contains(XMLUtils.getNodesPathName(receivedElement) + "." + receivedAttribute.getNodeName())) {
            return true;
        }
        for (String expression : ignoreMessageElements) {
            foundAttributeNode = XMLUtils.findNodeByName(receivedElement.getOwnerDocument(), expression);
            if (foundAttributeNode == null || !receivedAttribute.isSameNode(foundAttributeNode)) continue;
            return true;
        }
        for (String expression : ignoreMessageElements) {
            if (!XPathUtils.isXPathExpression(expression) || (foundAttributeNode = XPathUtils.evaluateAsNode(receivedElement.getOwnerDocument(), expression, namespaceContext)) == null || !foundAttributeNode.isSameNode(receivedAttribute)) continue;
            return true;
        }
        return false;
    }
}

