/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.xml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.callback.AbstractValidationCallback;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;

public abstract class XmlMarshallingValidationCallback<T>
extends AbstractValidationCallback<T> {
    private Unmarshaller unmarshaller;

    public XmlMarshallingValidationCallback() {
    }

    public XmlMarshallingValidationCallback(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Override
    public void validate(Message message, TestContext context) {
        this.validate(this.unmarshalMessage(message), message.getHeaders(), context);
    }

    private T unmarshalMessage(Message message) {
        if (this.unmarshaller == null) {
            Assert.notNull((Object)this.applicationContext, (String)"Marshalling validation callback requires marshaller instance or Spring application context with nested bean definition of type marshaller");
            this.unmarshaller = (Unmarshaller)this.applicationContext.getBean(Unmarshaller.class);
        }
        try {
            return (T)this.unmarshaller.unmarshal(this.getPayloadSource(message.getPayload()));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to unmarshal message payload", e);
        }
    }

    private Source getPayloadSource(Object payload) {
        Object source = null;
        if (payload instanceof String) {
            source = new StringSource((String)payload);
        } else if (payload instanceof File) {
            source = new StreamSource((File)payload);
        } else if (payload instanceof Document) {
            source = new DOMSource((Document)payload);
        } else if (payload instanceof Source) {
            source = (Source)payload;
        }
        if (source == null) {
            throw new CitrusRuntimeException("Failed to create payload source for unmarshalling message");
        }
        return source;
    }
}

