/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.xml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.validation.AbstractMessageValidator;
import com.consol.citrus.validation.ValidationUtils;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.validation.xml.XmlValidationUtils;
import com.consol.citrus.xml.XsdSchemaRepository;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import com.consol.citrus.xml.schema.WsdlXsdSchema;
import com.consol.citrus.xml.schema.XsdSchemaCollection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.xml.sax.SAXParseException;

public class DomXmlMessageValidator
extends AbstractMessageValidator<XmlMessageValidationContext>
implements ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(DomXmlMessageValidator.class);
    @Autowired(required=false)
    private List<XsdSchemaRepository> schemaRepositories = new ArrayList<XsdSchemaRepository>();
    @Autowired(required=false)
    private NamespaceContextBuilder namespaceContextBuilder = new NamespaceContextBuilder();
    private ApplicationContext applicationContext;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, XmlMessageValidationContext validationContext) throws ValidationException {
        log.debug("Start XML message validation ...");
        try {
            if (validationContext.isSchemaValidationEnabled()) {
                this.validateXMLSchema(receivedMessage, validationContext);
                this.validateDTD(validationContext.getDTDResource(), receivedMessage);
            }
            this.validateNamespaces(validationContext.getControlNamespaces(), receivedMessage);
            this.validateMessageContent(receivedMessage, controlMessage, validationContext, context);
            if (controlMessage != null) {
                Assert.isTrue((controlMessage.getHeaderData().size() <= receivedMessage.getHeaderData().size() ? 1 : 0) != 0, (String)("Failed to validate header data XML fragments - found " + receivedMessage.getHeaderData().size() + " header fragments, expected " + controlMessage.getHeaderData().size()));
                for (int i = 0; i < controlMessage.getHeaderData().size(); ++i) {
                    this.validateXmlHeaderFragment(receivedMessage.getHeaderData().get(i), controlMessage.getHeaderData().get(i), validationContext, context);
                }
            }
            log.info("XML message validation successful: All values OK");
        }
        catch (ClassCastException | DOMException | LSException e) {
            throw new CitrusRuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to validate:\n" + XMLUtils.prettyPrint(receivedMessage.getPayload(String.class)));
            throw new ValidationException("Validation failed:", e);
        }
        catch (ValidationException ex) {
            log.error("Failed to validate:\n" + XMLUtils.prettyPrint(receivedMessage.getPayload(String.class)));
            throw ex;
        }
    }

    protected void validateDTD(Resource dtdResource, Message receivedMessage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateXMLSchema(Message receivedMessage, XmlMessageValidationContext validationContext) {
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)receivedMessage.getPayload(String.class))) {
            return;
        }
        try {
            SAXParseException[] results;
            Document doc = XMLUtils.parseMessagePayload(receivedMessage.getPayload(String.class));
            if (!StringUtils.hasText((String)doc.getFirstChild().getNamespaceURI())) {
                return;
            }
            log.debug("Starting XML schema validation ...");
            XmlValidator validator = null;
            XsdSchemaRepository schemaRepository = null;
            if (validationContext.getSchema() != null) {
                validator = ((XsdSchema)this.applicationContext.getBean(validationContext.getSchema(), XsdSchema.class)).createValidator();
            } else if (validationContext.getSchemaRepository() != null) {
                schemaRepository = (XsdSchemaRepository)this.applicationContext.getBean(validationContext.getSchemaRepository(), XsdSchemaRepository.class);
            } else if (this.schemaRepositories.size() == 1) {
                schemaRepository = this.schemaRepositories.get(0);
            } else if (this.schemaRepositories.size() > 0) {
                for (XsdSchemaRepository xsdSchemaRepository : this.schemaRepositories) {
                    if (!xsdSchemaRepository.canValidate(doc)) continue;
                    schemaRepository = xsdSchemaRepository;
                }
                if (schemaRepository == null) {
                    throw new CitrusRuntimeException(String.format("Failed to find proper schema repository in Spring bean context for validating element '%s(%s)'", doc.getFirstChild().getLocalName(), doc.getFirstChild().getNamespaceURI()));
                }
            } else {
                log.warn("Neither schema instance nor schema repository defined - skipping XML schema validation");
                return;
            }
            if (schemaRepository != null) {
                if (!schemaRepository.canValidate(doc)) {
                    throw new CitrusRuntimeException(String.format("Unable to find proper XML schema definition for element '%s(%s)' in schema repository '%s'", doc.getFirstChild().getLocalName(), doc.getFirstChild().getNamespaceURI(), schemaRepository.getName()));
                }
                ArrayList<Object> schemas = new ArrayList<Object>();
                for (XsdSchema xsdSchema : schemaRepository.getSchemas()) {
                    if (xsdSchema instanceof XsdSchemaCollection) {
                        for (Resource resource : ((XsdSchemaCollection)xsdSchema).getSchemaResources()) {
                            schemas.add(resource);
                        }
                        continue;
                    }
                    if (xsdSchema instanceof WsdlXsdSchema) {
                        for (Resource resource : ((WsdlXsdSchema)xsdSchema).getSchemaResources()) {
                            schemas.add(resource);
                        }
                        continue;
                    }
                    Iterator<Resource> iterator = this.transformerFactory;
                    synchronized (iterator) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        try {
                            this.transformerFactory.newTransformer().transform(xsdSchema.getSource(), new StreamResult(bos));
                        }
                        catch (TransformerException e) {
                            throw new CitrusRuntimeException("Failed to read schema " + xsdSchema.getTargetNamespace(), e);
                        }
                        schemas.add(new ByteArrayResource(bos.toByteArray()));
                    }
                }
                validator = XmlValidatorFactory.createValidator((Resource[])schemas.toArray(new Resource[schemas.size()]), (String)"http://www.w3.org/2001/XMLSchema");
            }
            if ((results = validator.validate((Source)new DOMSource(doc))).length != 0) {
                log.error("XML schema validation failed for message:\n" + XMLUtils.prettyPrint(receivedMessage.getPayload(String.class)));
                log.debug("Found " + results.length + " schema validation errors");
                StringBuilder stringBuilder = new StringBuilder();
                for (SAXParseException e : results) {
                    stringBuilder.append(e.toString());
                    stringBuilder.append("\n");
                }
                log.debug(stringBuilder.toString());
                throw new ValidationException("XML schema validation failed:", results[0]);
            }
            log.info("XML schema validation successful: All values OK");
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(e);
        }
    }

    protected void validateNamespaces(Map<String, String> expectedNamespaces, Message receivedMessage) {
        if (CollectionUtils.isEmpty(expectedNamespaces)) {
            return;
        }
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)receivedMessage.getPayload(String.class))) {
            throw new ValidationException("Unable to validate message namespaces - receive message payload was empty");
        }
        log.debug("Start XML namespace validation");
        Document received = XMLUtils.parseMessagePayload(receivedMessage.getPayload(String.class));
        Map<String, String> foundNamespaces = XMLUtils.lookupNamespaces(receivedMessage.getPayload(String.class));
        if (foundNamespaces.size() != expectedNamespaces.size()) {
            throw new ValidationException("Number of namespace declarations not equal for node " + XMLUtils.getNodesPathName(received.getFirstChild()) + " found " + foundNamespaces.size() + " expected " + expectedNamespaces.size());
        }
        for (Map.Entry<String, String> entry : expectedNamespaces.entrySet()) {
            String namespace = entry.getKey();
            String url = entry.getValue();
            if (foundNamespaces.containsKey(namespace)) {
                if (!foundNamespaces.get(namespace).equals(url)) {
                    throw new ValidationException("Namespace '" + namespace + "' values not equal: found '" + foundNamespaces.get(namespace) + "' expected '" + url + "' in reference node " + XMLUtils.getNodesPathName(received.getFirstChild()));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Validating namespace " + namespace + " value as expected " + url + " - value OK");
                continue;
            }
            throw new ValidationException("Missing namespace " + namespace + "(" + url + ") in node " + XMLUtils.getNodesPathName(received.getFirstChild()));
        }
        log.info("XML namespace validation successful: All values OK");
    }

    private void doElementNameValidation(Node received, Node source) {
        if (log.isDebugEnabled()) {
            log.debug("Validating element: " + received.getLocalName() + " (" + received.getNamespaceURI() + ")");
        }
        Assert.isTrue((boolean)received.getLocalName().equals(source.getLocalName()), (String)ValidationUtils.buildValueMismatchErrorMessage("Element names not equal", source.getLocalName(), received.getLocalName()));
    }

    private void doElementNamespaceValidation(Node received, Node source) {
        if (log.isDebugEnabled()) {
            log.debug("Validating namespace for element: " + received.getLocalName());
        }
        if (received.getNamespaceURI() != null) {
            Assert.isTrue((source.getNamespaceURI() != null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Element namespace not equal for element '" + received.getLocalName() + "'", null, received.getNamespaceURI()));
            Assert.isTrue((boolean)received.getNamespaceURI().equals(source.getNamespaceURI()), (String)ValidationUtils.buildValueMismatchErrorMessage("Element namespace not equal for element '" + received.getLocalName() + "'", source.getNamespaceURI(), received.getNamespaceURI()));
        } else {
            Assert.isTrue((source.getNamespaceURI() == null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Element namespace not equal for element '" + received.getLocalName() + "'", source.getNamespaceURI(), null));
        }
    }

    protected void validateMessageContent(Message receivedMessage, Message controlMessage, XmlMessageValidationContext validationContext, TestContext context) {
        if (controlMessage == null || controlMessage.getPayload() == null) {
            log.debug("Skip message payload validation as no control message was defined");
            return;
        }
        if (!(controlMessage.getPayload() instanceof String)) {
            throw new IllegalArgumentException("DomXmlMessageValidator does only support message payload of type String, but was " + controlMessage.getPayload().getClass());
        }
        String controlMessagePayload = controlMessage.getPayload(String.class);
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)receivedMessage.getPayload(String.class))) {
            Assert.isTrue((!StringUtils.hasText((String)controlMessagePayload) ? 1 : 0) != 0, (String)"Unable to validate message payload - received message payload was empty, control message payload is not");
            return;
        }
        if (!StringUtils.hasText((String)controlMessagePayload)) {
            return;
        }
        log.debug("Start XML tree validation ...");
        Document received = XMLUtils.parseMessagePayload(receivedMessage.getPayload(String.class));
        Document source = XMLUtils.parseMessagePayload(controlMessagePayload);
        XMLUtils.stripWhitespaceNodes(received);
        XMLUtils.stripWhitespaceNodes(source);
        if (log.isDebugEnabled()) {
            log.debug("Received message:\n" + XMLUtils.serialize(received));
            log.debug("Control message:\n" + XMLUtils.serialize(source));
        }
        this.validateXmlTree(received, source, validationContext, this.namespaceContextBuilder.buildContext(receivedMessage, validationContext.getNamespaces()), context);
    }

    private void validateXmlHeaderFragment(String receivedHeaderData, String controlHeaderData, XmlMessageValidationContext validationContext, TestContext context) {
        log.debug("Start XML header data validation ...");
        Document received = XMLUtils.parseMessagePayload(receivedHeaderData);
        Document source = XMLUtils.parseMessagePayload(controlHeaderData);
        XMLUtils.stripWhitespaceNodes(received);
        XMLUtils.stripWhitespaceNodes(source);
        if (log.isDebugEnabled()) {
            log.debug("Received header data:\n" + XMLUtils.serialize(received));
            log.debug("Control header data:\n" + XMLUtils.serialize(source));
        }
        this.validateXmlTree(received, source, validationContext, this.namespaceContextBuilder.buildContext(new DefaultMessage(receivedHeaderData), validationContext.getNamespaces()), context);
    }

    private void validateXmlTree(Node received, Node source, XmlMessageValidationContext validationContext, NamespaceContext namespaceContext, TestContext context) {
        switch (received.getNodeType()) {
            case 10: {
                this.doDocumentTypeDefinition(received, source, validationContext, namespaceContext, context);
                break;
            }
            case 9: {
                this.validateXmlTree(received.getFirstChild(), source.getFirstChild(), validationContext, namespaceContext, context);
                break;
            }
            case 1: {
                this.doElement(received, source, validationContext, namespaceContext, context);
                break;
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 8: {
                this.validateXmlTree(received.getNextSibling(), source, validationContext, namespaceContext, context);
                break;
            }
            case 7: {
                this.doPI(received);
            }
        }
    }

    private void doDocumentTypeDefinition(Node received, Node source, XmlMessageValidationContext validationContext, NamespaceContext namespaceContext, TestContext context) {
        Assert.isTrue((boolean)(source instanceof DocumentType), (String)"Missing document type definition in expected xml fragment");
        DocumentType receivedDTD = (DocumentType)received;
        DocumentType sourceDTD = (DocumentType)source;
        if (log.isDebugEnabled()) {
            log.debug("Validating document type definition: " + receivedDTD.getPublicId() + " (" + receivedDTD.getSystemId() + ")");
        }
        if (!StringUtils.hasText((String)sourceDTD.getPublicId())) {
            Assert.isNull((Object)receivedDTD.getPublicId(), (String)ValidationUtils.buildValueMismatchErrorMessage("Document type public id not equal", sourceDTD.getPublicId(), receivedDTD.getPublicId()));
        } else if (sourceDTD.getPublicId().trim().equals("@ignore@")) {
            if (log.isDebugEnabled()) {
                log.debug("Document type public id: '" + receivedDTD.getPublicId() + "' is ignored by placeholder '" + "@ignore@" + "'");
            }
        } else {
            Assert.isTrue((StringUtils.hasText((String)receivedDTD.getPublicId()) && receivedDTD.getPublicId().equals(sourceDTD.getPublicId()) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Document type public id not equal", sourceDTD.getPublicId(), receivedDTD.getPublicId()));
        }
        if (!StringUtils.hasText((String)sourceDTD.getSystemId())) {
            Assert.isNull((Object)receivedDTD.getSystemId(), (String)ValidationUtils.buildValueMismatchErrorMessage("Document type system id not equal", sourceDTD.getSystemId(), receivedDTD.getSystemId()));
        } else if (sourceDTD.getSystemId().trim().equals("@ignore@")) {
            if (log.isDebugEnabled()) {
                log.debug("Document type system id: '" + receivedDTD.getSystemId() + "' is ignored by placeholder '" + "@ignore@" + "'");
            }
        } else {
            Assert.isTrue((StringUtils.hasText((String)receivedDTD.getSystemId()) && receivedDTD.getSystemId().equals(sourceDTD.getSystemId()) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Document type system id not equal", sourceDTD.getSystemId(), receivedDTD.getSystemId()));
        }
        this.validateXmlTree(received.getNextSibling(), source.getNextSibling(), validationContext, namespaceContext, context);
    }

    private void doElement(Node received, Node source, XmlMessageValidationContext validationContext, NamespaceContext namespaceContext, TestContext context) {
        this.doElementNameValidation(received, source);
        this.doElementNamespaceValidation(received, source);
        if (XmlValidationUtils.isElementIgnored(source, received, validationContext.getIgnoreExpressions(), namespaceContext)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating attributes for element: " + received.getLocalName());
        }
        NamedNodeMap receivedAttr = received.getAttributes();
        NamedNodeMap sourceAttr = source.getAttributes();
        Assert.isTrue((this.countAttributes(receivedAttr) == this.countAttributes(sourceAttr) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Number of attributes not equal for element '" + received.getLocalName() + "'", this.countAttributes(sourceAttr), this.countAttributes(receivedAttr)));
        for (int i = 0; i < receivedAttr.getLength(); ++i) {
            this.doAttribute(received, receivedAttr.item(i), source, validationContext, namespaceContext, context);
        }
        if (this.isValidationMatcherExpression(source)) {
            ValidationMatcherUtils.resolveValidationMatcher(source.getNodeName(), received.getFirstChild().getNodeValue().trim(), source.getFirstChild().getNodeValue().trim(), context);
            return;
        }
        this.doText((Element)received, (Element)source);
        List receivedChildElements = DomUtils.getChildElements((Element)((Element)received));
        List sourceChildElements = DomUtils.getChildElements((Element)((Element)source));
        Assert.isTrue((receivedChildElements.size() == sourceChildElements.size() ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Number of child elements not equal for element '" + received.getLocalName() + "'", sourceChildElements.size(), receivedChildElements.size()));
        for (int i = 0; i < receivedChildElements.size(); ++i) {
            this.validateXmlTree((Node)receivedChildElements.get(i), (Node)sourceChildElements.get(i), validationContext, namespaceContext, context);
        }
        if (log.isDebugEnabled()) {
            log.debug("Validation successful for element: " + received.getLocalName() + " (" + received.getNamespaceURI() + ")");
        }
    }

    private void doText(Element received, Element source) {
        if (log.isDebugEnabled()) {
            log.debug("Validating node value for element: " + received.getLocalName());
        }
        String receivedText = DomUtils.getTextValue((Element)received);
        String sourceText = DomUtils.getTextValue((Element)source);
        if (receivedText != null) {
            Assert.isTrue((sourceText != null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Node value not equal for element '" + received.getLocalName() + "'", null, receivedText.trim()));
            Assert.isTrue((boolean)receivedText.trim().equals(sourceText.trim()), (String)ValidationUtils.buildValueMismatchErrorMessage("Node value not equal for element '" + received.getLocalName() + "'", sourceText.trim(), receivedText.trim()));
        } else {
            Assert.isTrue((sourceText == null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Node value not equal for element '" + received.getLocalName() + "'", sourceText.trim(), null));
        }
        if (log.isDebugEnabled()) {
            log.debug("Node value '" + receivedText.trim() + "': OK");
        }
    }

    private void doAttribute(Node receivedElement, Node receivedAttribute, Node sourceElement, XmlMessageValidationContext validationContext, NamespaceContext namespaceContext, TestContext context) {
        NamedNodeMap sourceAttributes;
        Node sourceAttribute;
        if (receivedAttribute.getNodeName().startsWith("xmlns")) {
            return;
        }
        String receivedAttributeName = receivedAttribute.getLocalName();
        if (log.isDebugEnabled()) {
            log.debug("Validating attribute: " + receivedAttributeName + " (" + receivedAttribute.getNamespaceURI() + ")");
        }
        Assert.isTrue(((sourceAttribute = (sourceAttributes = sourceElement.getAttributes()).getNamedItemNS(receivedAttribute.getNamespaceURI(), receivedAttributeName)) != null ? 1 : 0) != 0, (String)("Attribute validation failed for element '" + receivedElement.getLocalName() + "', unknown attribute " + receivedAttributeName + " (" + receivedAttribute.getNamespaceURI() + ")"));
        if (XmlValidationUtils.isAttributeIgnored(receivedElement, receivedAttribute, sourceAttribute, validationContext.getIgnoreExpressions(), namespaceContext)) {
            return;
        }
        String receivedValue = receivedAttribute.getNodeValue();
        String sourceValue = sourceAttribute.getNodeValue();
        if (this.isValidationMatcherExpression(sourceAttribute)) {
            ValidationMatcherUtils.resolveValidationMatcher(sourceAttribute.getNodeName(), receivedAttribute.getNodeValue().trim(), sourceAttribute.getNodeValue().trim(), context);
        } else if (receivedValue.contains(":") && sourceValue.contains(":")) {
            this.doNamespaceQualifiedAttributeValidation(receivedElement, receivedAttribute, sourceElement, sourceAttribute);
        } else {
            Assert.isTrue((boolean)receivedValue.equals(sourceValue), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for attribute '" + receivedAttributeName + "'", sourceValue, receivedValue));
        }
        if (log.isDebugEnabled()) {
            log.debug("Attribute '" + receivedAttributeName + "'='" + receivedValue + "': OK");
        }
    }

    private void doNamespaceQualifiedAttributeValidation(Node receivedElement, Node receivedAttribute, Node sourceElement, Node sourceAttribute) {
        String receivedValue = receivedAttribute.getNodeValue();
        String sourceValue = sourceAttribute.getNodeValue();
        if (receivedValue.contains(":") && sourceValue.contains(":")) {
            String receivedPrefix = receivedValue.substring(0, receivedValue.indexOf(58));
            String sourcePrefix = sourceValue.substring(0, sourceValue.indexOf(58));
            Map<String, String> receivedNamespaces = XMLUtils.lookupNamespaces(receivedAttribute.getOwnerDocument());
            receivedNamespaces.putAll(XMLUtils.lookupNamespaces(receivedElement));
            if (receivedNamespaces.containsKey(receivedPrefix)) {
                Map<String, String> sourceNamespaces = XMLUtils.lookupNamespaces(sourceAttribute.getOwnerDocument());
                sourceNamespaces.putAll(XMLUtils.lookupNamespaces(sourceElement));
                if (sourceNamespaces.containsKey(sourcePrefix)) {
                    Assert.isTrue((boolean)sourceNamespaces.get(sourcePrefix).equals(receivedNamespaces.get(receivedPrefix)), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for attribute value namespace '" + receivedValue + "'", sourceNamespaces.get(sourcePrefix), receivedNamespaces.get(receivedPrefix)));
                    receivedValue = receivedValue.substring((receivedPrefix + ":").length());
                    sourceValue = sourceValue.substring((sourcePrefix + ":").length());
                } else {
                    throw new ValidationException("Received attribute value '" + receivedAttribute.getLocalName() + "' describes namespace qualified attribute value, control value '" + sourceValue + "' does not");
                }
            }
        }
        Assert.isTrue((boolean)receivedValue.equals(sourceValue), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for attribute '" + receivedAttribute.getLocalName() + "'", sourceValue, receivedValue));
    }

    private void doPI(Node received) {
        if (log.isDebugEnabled()) {
            log.debug("Ignored processing instruction (" + received.getLocalName() + "=" + received.getNodeValue() + ")");
        }
    }

    private int countAttributes(NamedNodeMap attributesR) {
        int cntAttributes = 0;
        for (int i = 0; i < attributesR.getLength(); ++i) {
            if (attributesR.item(i).getNodeName().startsWith("xmlns")) continue;
            ++cntAttributes;
        }
        return cntAttributes;
    }

    private boolean isValidationMatcherExpression(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return node.getFirstChild() != null && StringUtils.hasText((String)node.getFirstChild().getNodeValue()) && ValidationMatcherUtils.isValidationMatcherExpression(node.getFirstChild().getNodeValue().trim());
            }
            case 2: {
                return StringUtils.hasText((String)node.getNodeValue()) && ValidationMatcherUtils.isValidationMatcherExpression(node.getNodeValue().trim());
            }
        }
        return false;
    }

    @Override
    protected Class<XmlMessageValidationContext> getRequiredValidationContextType() {
        return XmlMessageValidationContext.class;
    }

    @Override
    public boolean supportsMessageType(String messageType, Message message) {
        if (!messageType.equalsIgnoreCase(MessageType.XML.name())) {
            return false;
        }
        if (!(message.getPayload() instanceof String)) {
            return false;
        }
        return !StringUtils.hasText((String)message.getPayload(String.class)) || message.getPayload(String.class).trim().startsWith("<");
    }

    public void addSchemaRepository(XsdSchemaRepository schemaRepository) {
        if (this.schemaRepositories == null) {
            this.schemaRepositories = new ArrayList<XsdSchemaRepository>();
        }
        this.schemaRepositories.add(schemaRepository);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

