/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.xhtml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.xhtml.XhtmlMessageConverter;
import com.consol.citrus.validation.xml.DomXmlMessageValidator;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import org.springframework.beans.factory.InitializingBean;

public class XhtmlMessageValidator
extends DomXmlMessageValidator
implements InitializingBean {
    private XhtmlMessageConverter messageConverter = new XhtmlMessageConverter();

    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, XmlMessageValidationContext validationContext) throws ValidationException {
        String messagePayload = receivedMessage.getPayload(String.class);
        super.validateMessage((Message)new DefaultMessage(this.messageConverter.convert(messagePayload), receivedMessage.getHeaders()), controlMessage, context, validationContext);
    }

    @Override
    public boolean supportsMessageType(String messageType, Message message) {
        return super.supportsMessageType(MessageType.XML.name(), message) && messageType.equalsIgnoreCase(MessageType.XHTML.name());
    }

    public void afterPropertiesSet() throws Exception {
        this.messageConverter.initialize();
    }

    public void setMessageConverter(XhtmlMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public XhtmlMessageConverter getMessageConverter() {
        return this.messageConverter;
    }
}

