/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.text;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.text.BinaryBase64MessageValidator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.springframework.util.StreamUtils;

public class GzipBinaryBase64MessageValidator
extends BinaryBase64MessageValidator {
    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) throws ValidationException {
        if (receivedMessage.getPayload() instanceof byte[]) {
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(receivedMessage.getPayload(InputStream.class));
                 ByteArrayOutputStream unzipped = new ByteArrayOutputStream();){
                StreamUtils.copy((InputStream)gzipInputStream, (OutputStream)unzipped);
                receivedMessage.setPayload(unzipped.toByteArray());
                unzipped.close();
                gzipInputStream.close();
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to validate gzipped message", e);
            }
        }
        super.validateMessage(receivedMessage, controlMessage, context, validationContext);
    }

    @Override
    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.GZIP_BASE64.toString());
    }
}

