/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.script.sql;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.script.GroovyScriptMessageValidator;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.script.TemplateBasedScriptBuilder;
import com.consol.citrus.validation.script.sql.SqlResultSetScriptExecutor;
import com.consol.citrus.validation.script.sql.SqlResultSetScriptValidator;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class GroovySqlResultSetValidator
implements SqlResultSetScriptValidator {
    private static Logger log = LoggerFactory.getLogger(GroovySqlResultSetValidator.class);
    private Resource scriptTemplateResource;

    public GroovySqlResultSetValidator() {
        this((Resource)new ClassPathResource("com/consol/citrus/validation/sql/sql-validation-template.groovy"));
    }

    public GroovySqlResultSetValidator(Resource scriptTemplateResource) {
        this.scriptTemplateResource = scriptTemplateResource;
    }

    @Override
    public void validateSqlResultSet(List<Map<String, Object>> resultSet, ScriptValidationContext validationContext, TestContext context) throws ValidationException {
        if (validationContext.getScriptType().equals("groovy")) {
            try {
                String validationScript = validationContext.getValidationScript(context);
                if (StringUtils.hasText((String)validationScript)) {
                    log.debug("Start groovy SQL result set validation");
                    GroovyClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

                        @Override
                        public GroovyClassLoader run() {
                            return new GroovyClassLoader(GroovyScriptMessageValidator.class.getClassLoader());
                        }
                    });
                    Class groovyClass = loader.parseClass(TemplateBasedScriptBuilder.fromTemplateResource(this.scriptTemplateResource).withCode(validationScript).build());
                    if (groovyClass == null) {
                        throw new CitrusRuntimeException("Failed to load groovy validation script resource");
                    }
                    GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
                    ((SqlResultSetScriptExecutor)groovyObject).validate(resultSet, context);
                    log.info("Groovy SQL result set validation successful: All values OK");
                }
            }
            catch (CompilationFailedException e) {
                throw new CitrusRuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new CitrusRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new CitrusRuntimeException(e);
            }
            catch (AssertionError e) {
                throw new ValidationException("Groovy SQL result set validation failed with assertion error:\n" + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
        }
    }
}

