/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.script;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.springframework.core.io.Resource;

public final class TemplateBasedScriptBuilder {
    private static final String BODY_PLACEHOLDER = "@SCRIPTBODY@";
    private String scriptHead;
    private String scriptTail;
    private String scriptCode = "";

    private TemplateBasedScriptBuilder(String scriptTemplate) {
        if (!scriptTemplate.contains(BODY_PLACEHOLDER)) {
            throw new CitrusRuntimeException("Invalid script template - please define '@SCRIPTBODY@' placeholder where your code comes in");
        }
        this.scriptHead = scriptTemplate.substring(0, scriptTemplate.indexOf(BODY_PLACEHOLDER));
        this.scriptTail = scriptTemplate.substring(scriptTemplate.indexOf(BODY_PLACEHOLDER) + BODY_PLACEHOLDER.length());
    }

    public String build() {
        StringBuilder scriptBuilder = new StringBuilder();
        StringBuilder scriptBody = new StringBuilder();
        String importStmt = "import ";
        try {
            if (this.scriptCode.contains(importStmt)) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(this.scriptCode));
                while ((line = reader.readLine()) != null) {
                    if (line.trim().startsWith(importStmt)) {
                        scriptBuilder.append(line);
                        scriptBuilder.append("\n");
                        continue;
                    }
                    scriptBody.append(scriptBody.length() == 0 ? "" : "\n");
                    scriptBody.append(line);
                }
            } else {
                scriptBody.append(this.scriptCode);
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to construct script from template", e);
        }
        scriptBuilder.append(this.scriptHead);
        scriptBuilder.append(scriptBody.toString());
        scriptBuilder.append(this.scriptTail);
        return scriptBuilder.toString();
    }

    public TemplateBasedScriptBuilder withCode(String code) {
        this.scriptCode = code;
        return this;
    }

    public static TemplateBasedScriptBuilder fromTemplateScript(String scriptTemplate) {
        return new TemplateBasedScriptBuilder(scriptTemplate);
    }

    public static TemplateBasedScriptBuilder fromTemplateResource(Resource scriptTemplateResource) {
        try {
            return new TemplateBasedScriptBuilder(FileUtils.readToString(scriptTemplateResource.getInputStream()));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Error loading script template from file resource", e);
        }
    }
}

