/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.script;

import com.consol.citrus.Citrus;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.context.DefaultValidationContext;
import java.io.IOException;
import java.nio.charset.Charset;

public class ScriptValidationContext
extends DefaultValidationContext {
    private String validationScriptResourcePath;
    private String validationScriptResourceCharset = Citrus.CITRUS_FILE_ENCODING;
    private String validationScript = "";
    private String scriptType = "groovy";
    private final String messageType;

    public ScriptValidationContext(String messageType) {
        this.messageType = messageType;
    }

    public ScriptValidationContext(String scriptType, String messageType) {
        this(messageType);
        this.scriptType = scriptType;
    }

    public String getValidationScript(TestContext context) {
        try {
            if (this.validationScriptResourcePath != null) {
                return context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.validationScriptResourcePath, context), Charset.forName(context.replaceDynamicContentInString(this.validationScriptResourceCharset))));
            }
            if (this.validationScript != null) {
                return context.replaceDynamicContentInString(this.validationScript);
            }
            return "";
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to load validation script resource", e);
        }
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public String getValidationScriptResourcePath() {
        return this.validationScriptResourcePath;
    }

    public void setValidationScriptResourcePath(String validationScriptResource) {
        this.validationScriptResourcePath = validationScriptResource;
    }

    public String getValidationScript() {
        return this.validationScript;
    }

    public void setValidationScript(String validationScript) {
        this.validationScript = validationScript;
    }

    public void setScriptType(String scriptType) {
        this.scriptType = scriptType;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getValidationScriptResourceCharset() {
        return this.validationScriptResourceCharset;
    }

    public void setValidationScriptResourceCharset(String validationScriptResourceCharset) {
        this.validationScriptResourceCharset = validationScriptResourceCharset;
    }
}

