/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.script;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.AbstractMessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.script.GroovyScriptExecutor;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.script.TemplateBasedScriptBuilder;
import com.consol.citrus.validation.text.PlainTextMessageValidator;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class GroovyScriptMessageValidator
extends AbstractMessageValidator<ScriptValidationContext> {
    private static Logger log = LoggerFactory.getLogger(GroovyScriptMessageValidator.class);
    private Resource scriptTemplateResource;

    public GroovyScriptMessageValidator() {
        this(new ClassPathResource("com/consol/citrus/validation/script-validation-template.groovy"));
    }

    public GroovyScriptMessageValidator(ClassPathResource scriptTemplateResource) {
        this.scriptTemplateResource = scriptTemplateResource;
    }

    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ScriptValidationContext validationContext) throws ValidationException {
        try {
            String validationScript = validationContext.getValidationScript(context);
            if (StringUtils.hasText((String)validationScript)) {
                log.debug("Start groovy message validation ...");
                GroovyClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

                    @Override
                    public GroovyClassLoader run() {
                        return new GroovyClassLoader(GroovyScriptMessageValidator.class.getClassLoader());
                    }
                });
                Class groovyClass = loader.parseClass(TemplateBasedScriptBuilder.fromTemplateResource(this.scriptTemplateResource).withCode(validationScript).build());
                if (groovyClass == null) {
                    throw new CitrusRuntimeException("Failed to load groovy validation script resource");
                }
                GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
                ((GroovyScriptExecutor)groovyObject).validate(receivedMessage, context);
                log.info("Groovy message validation successful: All values OK");
            }
        }
        catch (IllegalAccessException | InstantiationException | CompilationFailedException e) {
            throw new CitrusRuntimeException(e);
        }
        catch (AssertionError e) {
            throw new ValidationException("Groovy script validation failed with assertion error:\n" + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    protected ScriptValidationContext findValidationContext(List<ValidationContext> validationContexts) {
        for (ValidationContext validationContext : validationContexts) {
            if (!this.getRequiredValidationContextType().isInstance(validationContext) || !((ScriptValidationContext)validationContext).getScriptType().equals("groovy")) continue;
            return (ScriptValidationContext)validationContext;
        }
        return null;
    }

    @Override
    protected Class<ScriptValidationContext> getRequiredValidationContextType() {
        return ScriptValidationContext.class;
    }

    @Override
    public boolean supportsMessageType(String messageType, Message message) {
        return new PlainTextMessageValidator().supportsMessageType(messageType, message);
    }
}

