/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.script;

import com.consol.citrus.Citrus;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.script.TemplateBasedScriptBuilder;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.nio.charset.Charset;
import org.codehaus.groovy.control.CompilationFailedException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class GroovyScriptMessageBuilder
extends AbstractMessageContentBuilder {
    private Resource scriptTemplateResource = new ClassPathResource("com/consol/citrus/script/markup-builder-template.groovy");
    private String scriptResourcePath;
    private String scriptResourceCharset = Citrus.CITRUS_FILE_ENCODING;
    private String scriptData;

    @Override
    public String buildMessagePayload(TestContext context, String messageType) {
        try {
            String messagePayload = "";
            if (this.scriptResourcePath != null) {
                messagePayload = this.buildMarkupBuilderScript(context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.scriptResourcePath, context), Charset.forName(context.resolveDynamicValue(this.scriptResourceCharset)))));
            } else if (this.scriptData != null) {
                messagePayload = this.buildMarkupBuilderScript(context.replaceDynamicContentInString(this.scriptData));
            }
            return messagePayload;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to build control message payload", e);
        }
    }

    private String buildMarkupBuilderScript(String scriptData) {
        try {
            ClassLoader parent = GroovyScriptMessageBuilder.class.getClassLoader();
            GroovyClassLoader loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(TemplateBasedScriptBuilder.fromTemplateResource(this.scriptTemplateResource).withCode(scriptData).build());
            if (groovyClass == null) {
                throw new CitrusRuntimeException("Could not load groovy script!");
            }
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            return (String)groovyObject.invokeMethod("run", (Object)new Object[0]);
        }
        catch (CompilationFailedException e) {
            throw new CitrusRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new CitrusRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new CitrusRuntimeException(e);
        }
    }

    public void setScriptData(String scriptData) {
        this.scriptData = scriptData;
    }

    public void setScriptResourcePath(String scriptResource) {
        this.scriptResourcePath = scriptResource;
    }

    public String getScriptResourcePath() {
        return this.scriptResourcePath;
    }

    public String getScriptData() {
        return this.scriptData;
    }

    public String getScriptResourceCharset() {
        return this.scriptResourceCharset;
    }

    public void setScriptResourceCharset(String scriptResourceCharset) {
        this.scriptResourceCharset = scriptResourceCharset;
    }
}

