/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.matcher.hamcrest;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.matcher.ControlExpressionParser;
import com.consol.citrus.validation.matcher.DefaultControlExpressionParser;
import com.consol.citrus.validation.matcher.ValidationMatcher;
import com.consol.citrus.validation.matcher.hamcrest.HamcrestMatcherProvider;
import com.consol.citrus.variable.VariableUtils;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class HamcrestValidationMatcher
implements ValidationMatcher,
ControlExpressionParser {
    private List<String> matchers = Arrays.asList("equalTo", "equalToIgnoringCase", "equalToIgnoringWhiteSpace", "is", "not", "containsString", "startsWith", "endsWith");
    private List<String> collectionMatchers = Arrays.asList("hasSize", "hasItem", "hasItems", "contains", "containsInAnyOrder");
    private List<String> mapMatchers = Arrays.asList("hasEntry", "hasKey", "hasValue");
    private List<String> optionMatchers = Arrays.asList("isOneOf", "isIn");
    private List<String> numericMatchers = Arrays.asList("greaterThan", "greaterThanOrEqualTo", "lessThan", "lessThanOrEqualTo", "closeTo");
    private List<String> containerMatchers = Arrays.asList("is", "not", "everyItem");
    private List<String> noArgumentMatchers = Arrays.asList("isEmptyString", "isEmptyOrNullString", "nullValue", "notNullValue", "anything");
    private List<String> noArgumentCollectionMatchers = Collections.singletonList("empty");
    private List<String> iterableMatchers = Arrays.asList("anyOf", "allOf");
    @Autowired
    private List<HamcrestMatcherProvider> customMatchers = new ArrayList<HamcrestMatcherProvider>();

    @Override
    public void validate(String fieldName, String value, List<String> controlParameters, TestContext context) throws ValidationException {
        String matcherExpression;
        String matcherValue = value;
        if (controlParameters.size() > 1) {
            matcherValue = context.replaceDynamicContentInString(controlParameters.get(0));
            matcherExpression = controlParameters.get(1);
        } else {
            matcherExpression = controlParameters.get(0);
        }
        String matcherName = matcherExpression.trim().substring(0, matcherExpression.trim().indexOf("("));
        String[] matcherParameter = matcherExpression.trim().substring(matcherName.length() + 1, matcherExpression.trim().length() - 1).split(",");
        for (int i = 0; i < matcherParameter.length; ++i) {
            matcherParameter[i] = VariableUtils.cutOffSingleQuotes(matcherParameter[i].trim());
        }
        Matcher<?> matcher = this.getMatcher(matcherName, matcherParameter);
        if (this.noArgumentCollectionMatchers.contains(matcherName) || this.collectionMatchers.contains(matcherName) || matcherName.equals("everyItem")) {
            MatcherAssert.assertThat(this.getCollection(matcherValue), matcher);
        } else if (this.mapMatchers.contains(matcherName)) {
            MatcherAssert.assertThat(this.getMap(matcherValue), matcher);
        } else if (this.numericMatchers.contains(matcherName)) {
            if (matcherName.equals("closeTo")) {
                MatcherAssert.assertThat((Object)Double.valueOf(matcherValue), matcher);
            } else {
                MatcherAssert.assertThat((Object)new NumericComparable(matcherValue), matcher);
            }
        } else if (this.iterableMatchers.contains(matcherName) && this.containsNumericMatcher(matcherExpression)) {
            MatcherAssert.assertThat((Object)new NumericComparable(matcherValue), matcher);
        } else {
            MatcherAssert.assertThat((Object)matcherValue, matcher);
        }
    }

    private Matcher<?> getMatcher(String matcherName, String[] matcherParameter) {
        try {
            Method matcherMethod;
            String matcherExpression;
            Method matcherMethod2;
            if (this.noArgumentMatchers.contains(matcherName) && (matcherMethod2 = ReflectionUtils.findMethod(Matchers.class, (String)matcherName)) != null) {
                return (Matcher)matcherMethod2.invoke(null, new Object[0]);
            }
            if (this.noArgumentCollectionMatchers.contains(matcherName) && (matcherMethod2 = ReflectionUtils.findMethod(Matchers.class, (String)matcherName)) != null) {
                return (Matcher)matcherMethod2.invoke(null, new Object[0]);
            }
            Assert.isTrue((matcherParameter.length > 0 ? 1 : 0) != 0, (String)"Missing matcher parameter");
            if (this.containerMatchers.contains(matcherName) && (matcherMethod2 = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Matcher.class})) != null && (matcherExpression = matcherParameter[0]).contains("(") && matcherExpression.contains(")")) {
                String nestedMatcherName = matcherExpression.trim().substring(0, matcherExpression.trim().indexOf("("));
                String[] nestedMatcherParameter = matcherExpression.trim().substring(nestedMatcherName.length() + 1, matcherExpression.trim().length() - 1).split(",");
                return (Matcher)matcherMethod2.invoke(null, this.getMatcher(nestedMatcherName, nestedMatcherParameter));
            }
            if (this.iterableMatchers.contains(matcherName) && (matcherMethod2 = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Iterable.class})) != null) {
                ArrayList nestedMatchers = new ArrayList();
                for (String matcherExpression2 : matcherParameter) {
                    String nestedMatcherName = matcherExpression2.trim().substring(0, matcherExpression2.trim().indexOf("("));
                    String nestedMatcherParameter = matcherExpression2.trim().substring(nestedMatcherName.length() + 1, matcherExpression2.trim().length() - 1);
                    nestedMatchers.add(this.getMatcher(nestedMatcherName, new String[]{nestedMatcherParameter}));
                }
                return (Matcher)matcherMethod2.invoke(null, nestedMatchers);
            }
            Optional<HamcrestMatcherProvider> matcherProvider = this.customMatchers.stream().filter(provider -> provider.getName().equals(matcherName)).findFirst();
            if (matcherProvider.isPresent()) {
                return matcherProvider.get().provideMatcher(matcherParameter[0]);
            }
            if (this.matchers.contains(matcherName)) {
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{String.class});
                if (matcherMethod == null) {
                    matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object.class});
                }
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, matcherParameter[0]);
                }
            }
            if (this.numericMatchers.contains(matcherName)) {
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Double.TYPE, Double.TYPE});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, Double.valueOf(matcherParameter[0]), matcherParameter.length > 1 ? Double.valueOf(matcherParameter[1]) : 0.0);
                }
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Comparable.class});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, matcherParameter[0]);
                }
            }
            if (this.collectionMatchers.contains(matcherName)) {
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Integer.TYPE});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, Integer.valueOf(matcherParameter[0]));
                }
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object.class});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, matcherParameter[0]);
                }
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object[].class});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, new Object[]{matcherParameter});
                }
            }
            if (this.mapMatchers.contains(matcherName)) {
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object.class});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, matcherParameter[0]);
                }
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object.class, Object.class});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, matcherParameter[0], matcherParameter[1]);
                }
            }
            if (this.optionMatchers.contains(matcherName)) {
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object[].class});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, new Object[]{matcherParameter});
                }
                matcherMethod = ReflectionUtils.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Collection.class});
                if (matcherMethod != null) {
                    return (Matcher)matcherMethod.invoke(null, this.getCollection(StringUtils.arrayToCommaDelimitedString((Object[])matcherParameter)));
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CitrusRuntimeException("Failed to invoke matcher", e);
        }
        throw new CitrusRuntimeException("Unsupported matcher: " + matcherName);
    }

    private List<String> getCollection(String value) {
        String arrayString = value;
        if (arrayString.startsWith("[") && arrayString.endsWith("]")) {
            arrayString = arrayString.substring(1, arrayString.length() - 1);
        }
        return Arrays.stream(StringUtils.commaDelimitedListToStringArray((String)arrayString)).map(String::trim).map(VariableUtils::cutOffDoubleQuotes).collect(Collectors.toList());
    }

    private Map<String, Object> getMap(String mapString) {
        Properties props = new Properties();
        try {
            props.load(new StringReader(mapString.substring(1, mapString.length() - 1).replaceAll(",\\s*", "\n")));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to reconstruct object of type map", e);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey() instanceof String ? VariableUtils.cutOffDoubleQuotes(entry.getKey().toString()) : entry.getKey().toString();
            Object value = entry.getValue() instanceof String ? VariableUtils.cutOffDoubleQuotes(entry.getValue().toString()).trim() : entry.getValue();
            map.put(key, value);
        }
        return map;
    }

    private boolean containsNumericMatcher(String matcherExpression) {
        for (String numericMatcher : this.numericMatchers) {
            if (!matcherExpression.contains(numericMatcher)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> extractControlValues(String controlExpression, Character delimiter) {
        if (controlExpression.startsWith("'") && controlExpression.contains("',")) {
            return new DefaultControlExpressionParser().extractControlValues(controlExpression, delimiter);
        }
        return Collections.singletonList(controlExpression);
    }

    private class NumericComparable
    implements Comparable {
        private Long number = null;
        private Double decimal = null;

        public NumericComparable(String value) {
            if (value.contains(".")) {
                this.decimal = Double.parseDouble(value);
            } else {
                try {
                    this.number = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        public int compareTo(Object o) {
            if (this.number != null) {
                if (o instanceof String || o instanceof NumericComparable) {
                    return this.number.compareTo(Long.parseLong(o.toString()));
                }
                if (o instanceof Long) {
                    return this.number.compareTo((Long)o);
                }
            }
            if (this.decimal != null) {
                if (o instanceof String || o instanceof NumericComparable) {
                    return this.decimal.compareTo(Double.parseDouble(o.toString()));
                }
                if (o instanceof Double) {
                    return this.decimal.compareTo((Double)o);
                }
            }
            return 0;
        }

        public String toString() {
            if (this.number != null) {
                return this.number.toString();
            }
            return this.decimal.toString();
        }
    }
}

