/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.matcher.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.matcher.ValidationMatcher;
import com.consol.citrus.validation.xml.DomXmlMessageValidator;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XmlValidationMatcher
implements ValidationMatcher,
ApplicationContextAware,
InitializingBean {
    private static final String CDATA_SECTION_START = "<![CDATA[";
    private static final String CDATA_SECTION_END = "]]>";
    @Autowired(required=false)
    private MessageValidatorRegistry messageValidatorRegistry;
    private DomXmlMessageValidator xmlMessageValidator;
    private ApplicationContext applicationContext;
    private static final Logger LOG = LoggerFactory.getLogger(XmlValidationMatcher.class);

    @Override
    public void validate(String fieldName, String value, List<String> controlParameters, TestContext context) throws ValidationException {
        String control = controlParameters.get(0);
        XmlMessageValidationContext validationContext = new XmlMessageValidationContext();
        this.xmlMessageValidator.validateMessage((Message)new DefaultMessage(this.removeCDataElements(value)), (Message)new DefaultMessage(control), context, validationContext);
    }

    private String removeCDataElements(String value) {
        String data = value.trim();
        if (data.startsWith(CDATA_SECTION_START)) {
            data = value.substring(CDATA_SECTION_START.length());
            data = data.substring(0, data.length() - CDATA_SECTION_END.length());
        }
        return data;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        for (MessageValidator<? extends ValidationContext> messageValidator : this.messageValidatorRegistry.getMessageValidators()) {
            if (!(messageValidator instanceof DomXmlMessageValidator) || !messageValidator.supportsMessageType(MessageType.XML.name(), new DefaultMessage(""))) continue;
            this.xmlMessageValidator = (DomXmlMessageValidator)messageValidator;
        }
        if (this.xmlMessageValidator == null) {
            LOG.warn("No XML message validator found in Spring bean context - setting default validator");
            this.xmlMessageValidator = new DomXmlMessageValidator();
            this.xmlMessageValidator.setApplicationContext(this.applicationContext);
        }
    }
}

