/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json.schema;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.json.JsonSchemaRepository;
import com.consol.citrus.json.schema.SimpleJsonSchema;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class JsonSchemaFilter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public List<SimpleJsonSchema> filter(List<JsonSchemaRepository> schemaRepositories, JsonMessageValidationContext jsonMessageValidationContext, ApplicationContext applicationContext) {
        if (this.isSchemaRepositorySpecified(jsonMessageValidationContext)) {
            return this.filterByRepositoryName(schemaRepositories, jsonMessageValidationContext);
        }
        if (this.isSchemaSpecified(jsonMessageValidationContext)) {
            return this.getSchemaFromContext(jsonMessageValidationContext, applicationContext);
        }
        return this.mergeRepositories(schemaRepositories);
    }

    private List<SimpleJsonSchema> getSchemaFromContext(JsonMessageValidationContext jsonMessageValidationContext, ApplicationContext applicationContext) {
        try {
            SimpleJsonSchema simpleJsonSchema = (SimpleJsonSchema)applicationContext.getBean(jsonMessageValidationContext.getSchema(), SimpleJsonSchema.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found specified schema: \"" + jsonMessageValidationContext.getSchema() + "\".");
            }
            return Collections.singletonList(simpleJsonSchema);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new CitrusRuntimeException("Could not find the specified schema: \"" + jsonMessageValidationContext.getSchema() + "\".", e);
        }
    }

    private List<SimpleJsonSchema> filterByRepositoryName(List<JsonSchemaRepository> schemaRepositories, JsonMessageValidationContext jsonMessageValidationContext) {
        for (JsonSchemaRepository jsonSchemaRepository : schemaRepositories) {
            if (!Objects.equals(jsonSchemaRepository.getName(), jsonMessageValidationContext.getSchemaRepository())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found specified schema-repository: \"" + jsonMessageValidationContext.getSchemaRepository() + "\".");
            }
            return jsonSchemaRepository.getSchemas();
        }
        throw new CitrusRuntimeException("Could not find the specified schema repository: \"" + jsonMessageValidationContext.getSchemaRepository() + "\".");
    }

    private List<SimpleJsonSchema> mergeRepositories(List<JsonSchemaRepository> schemaRepositories) {
        return schemaRepositories.stream().map(JsonSchemaRepository::getSchemas).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean isSchemaSpecified(JsonMessageValidationContext context) {
        return StringUtils.hasText((String)context.getSchema());
    }

    private boolean isSchemaRepositorySpecified(JsonMessageValidationContext context) {
        return StringUtils.hasText((String)context.getSchemaRepository());
    }
}

