/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json.report;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class GraciousProcessingReport
implements ProcessingReport {
    private LogLevel currentLevel = LogLevel.DEBUG;
    private LogLevel logLevel = LogLevel.INFO;
    private LogLevel exceptionThreshold = LogLevel.FATAL;
    private boolean success;
    private final List<ProcessingMessage> messages = new ArrayList<ProcessingMessage>();

    public GraciousProcessingReport(boolean success) {
        this.success = success;
    }

    public GraciousProcessingReport(List<ProcessingReport> processingReports) {
        this(false);
        for (ProcessingReport processingReport : processingReports) {
            this.mergeWith(processingReport);
        }
    }

    public void mergeWith(ProcessingReport processingReport) {
        this.success = this.success || processingReport.isSuccess();
        processingReport.forEach(this.messages::add);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public LogLevel getExceptionThreshold() {
        return this.exceptionThreshold;
    }

    public void debug(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.DEBUG));
    }

    public void info(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.INFO));
    }

    public void warn(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.WARNING));
    }

    public void error(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.ERROR));
    }

    public void fatal(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.FATAL));
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<ProcessingMessage> getMessages() {
        return this.messages;
    }

    @Nonnull
    public Iterator<ProcessingMessage> iterator() {
        return Iterators.unmodifiableIterator(this.messages.iterator());
    }

    private void dispatch(ProcessingMessage message) throws ProcessingException {
        LogLevel level = message.getLogLevel();
        if (level.compareTo((Enum)this.exceptionThreshold) >= 0) {
            throw message.asException();
        }
        if (level.compareTo((Enum)this.currentLevel) > 0) {
            this.currentLevel = level;
        }
        if (level.compareTo((Enum)this.logLevel) >= 0) {
            this.log(message);
        }
    }

    public void log(ProcessingMessage message) {
        this.messages.add(message);
    }
}

