/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.json.JsonPathUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.variable.VariableExtractor;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class JsonPathVariableExtractor
implements VariableExtractor {
    private Map<String, String> jsonPathExpressions = new HashMap<String, String>();
    private static Logger log = LoggerFactory.getLogger(JsonPathVariableExtractor.class);

    @Override
    public void extractVariables(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.jsonPathExpressions)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Reading JSON elements with JSONPath");
        }
        try {
            JSONParser parser = new JSONParser(1984);
            Object receivedJson = parser.parse(message.getPayload(String.class));
            DocumentContext readerContext = JsonPath.parse((Object)receivedJson);
            for (Map.Entry<String, String> entry : this.jsonPathExpressions.entrySet()) {
                Object jsonPathResult;
                String jsonPathExpression = context.replaceDynamicContentInString(entry.getKey());
                String variableName = entry.getValue();
                if (log.isDebugEnabled()) {
                    log.debug("Evaluating JSONPath expression: " + jsonPathExpression);
                }
                if ((jsonPathResult = JsonPathUtils.evaluate((ReadContext)readerContext, jsonPathExpression)) instanceof JSONArray) {
                    context.setVariable(variableName, ((JSONArray)jsonPathResult).toJSONString());
                    continue;
                }
                if (jsonPathResult instanceof JSONObject) {
                    context.setVariable(variableName, ((JSONObject)jsonPathResult).toJSONString());
                    continue;
                }
                context.setVariable(variableName, Optional.ofNullable(jsonPathResult).orElse("null"));
            }
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", e);
        }
    }

    public void setJsonPathExpressions(Map<String, String> jsonPathExpressions) {
        this.jsonPathExpressions = jsonPathExpressions;
    }

    public Map<String, String> getJsonPathExpressions() {
        return this.jsonPathExpressions;
    }
}

