/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.UnknownElementException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.interceptor.AbstractMessageConstructionInterceptor;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class JsonPathMessageConstructionInterceptor
extends AbstractMessageConstructionInterceptor {
    private static Logger log = LoggerFactory.getLogger(JsonPathMessageConstructionInterceptor.class);
    private Map<String, String> jsonPathExpressions = new HashMap<String, String>();
    private boolean ignoreNotFound = false;

    public JsonPathMessageConstructionInterceptor() {
    }

    public JsonPathMessageConstructionInterceptor(Map<String, String> jsonPathExpressions) {
        this.jsonPathExpressions = jsonPathExpressions;
    }

    @Override
    public Message interceptMessage(Message message, String messageType, TestContext context) {
        if (message.getPayload() == null || !StringUtils.hasText((String)message.getPayload(String.class))) {
            return message;
        }
        String jsonPathExpression = null;
        try {
            JSONParser parser = new JSONParser(1984);
            Object jsonData = parser.parse(message.getPayload(String.class));
            DocumentContext documentContext = JsonPath.parse((Object)jsonData);
            for (Map.Entry<String, String> entry : this.jsonPathExpressions.entrySet()) {
                String valueExpression;
                block12: {
                    Object value;
                    jsonPathExpression = entry.getKey();
                    valueExpression = context.replaceDynamicContentInString(entry.getValue());
                    if (valueExpression.equals("true")) {
                        value = true;
                    } else if (valueExpression.equals("false")) {
                        value = false;
                    } else {
                        try {
                            value = NumberUtils.parseNumber((String)valueExpression, Integer.class);
                        }
                        catch (IllegalArgumentException e) {
                            value = valueExpression;
                        }
                    }
                    try {
                        documentContext.set(jsonPathExpression, value, new Predicate[0]);
                    }
                    catch (PathNotFoundException e) {
                        if (this.ignoreNotFound) break block12;
                        throw new UnknownElementException(String.format("Could not find element for expression: %s", jsonPathExpression), e);
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Element " + jsonPathExpression + " was set to value: " + valueExpression);
            }
            message.setPayload(jsonData.toString());
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", e);
        }
        return message;
    }

    @Override
    public boolean supportsMessageType(String messageType) {
        return MessageType.JSON.toString().equalsIgnoreCase(messageType);
    }

    public void setJsonPathExpressions(Map<String, String> jsonPathExpressions) {
        this.jsonPathExpressions = jsonPathExpressions;
    }

    public Map<String, String> getJsonPathExpressions() {
        return this.jsonPathExpressions;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }
}

