/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.interceptor;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageDirection;
import com.consol.citrus.validation.interceptor.MessageConstructionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageConstructionInterceptor
implements MessageConstructionInterceptor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MessageDirection direction = MessageDirection.UNBOUND;

    @Override
    public Message interceptMessageConstruction(Message message, String messageType, TestContext context) {
        if (this.supportsMessageType(messageType)) {
            return this.interceptMessage(message, messageType, context);
        }
        this.log.debug(String.format("Message interceptor type '%s' skipped for message type: %s", this.getName(), messageType));
        return message;
    }

    protected String getName() {
        return this.getClass().getSimpleName();
    }

    protected Message interceptMessage(Message message, String messageType, TestContext context) {
        return message;
    }

    @Override
    public MessageDirection getDirection() {
        return this.direction;
    }

    public void setDirection(MessageDirection direction) {
        this.direction = direction;
    }
}

