/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.builder;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaticMessageContentBuilder
extends AbstractMessageContentBuilder {
    private Message message;

    public StaticMessageContentBuilder(Message message) {
        this.message = message;
        this.setMessageName(message.getName());
    }

    @Override
    public Object buildMessagePayload(TestContext context, String messageType) {
        if (this.message.getPayload() instanceof String) {
            return context.replaceDynamicContentInString(this.message.getPayload(String.class));
        }
        return this.message.getPayload();
    }

    @Override
    public Map<String, Object> buildMessageHeaders(TestContext context, String messageType) {
        Map<String, Object> headers = super.buildMessageHeaders(context, messageType);
        headers.putAll(context.resolveDynamicValuesInMap(this.message.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("citrus_message_id") && !((String)entry.getKey()).equals("citrus_message_timestamp")).collect(HashMap::new, (map, value) -> map.put(value.getKey(), value.getValue()), HashMap::putAll)));
        return headers;
    }

    @Override
    public List<String> buildMessageHeaderData(TestContext context) {
        List<String> headerData = super.buildMessageHeaderData(context);
        headerData.addAll(context.resolveDynamicValuesInList(this.message.getHeaderData()));
        return headerData;
    }

    public static StaticMessageContentBuilder withMessage(Message message) {
        return new StaticMessageContentBuilder(message);
    }

    public Message getMessage() {
        return this.message;
    }
}

