/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.builder;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageDirection;
import com.consol.citrus.message.MessageHeaderType;
import com.consol.citrus.message.MessageHeaderUtils;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.interceptor.MessageConstructionInterceptor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMessageContentBuilder
implements MessageContentBuilder {
    private String messageName = "";
    private Map<String, Object> messageHeaders = new LinkedHashMap<String, Object>();
    private List<String> headerResources = new ArrayList<String>();
    private List<String> headerData = new ArrayList<String>();
    private DataDictionary dataDictionary;
    private List<MessageConstructionInterceptor> messageInterceptors = new ArrayList<MessageConstructionInterceptor>();

    public Message buildMessageContent(TestContext context, String messageType) {
        return this.buildMessageContent(context, messageType, MessageDirection.UNBOUND);
    }

    @Override
    public Message buildMessageContent(TestContext context, String messageType, MessageDirection direction) {
        Object payload = this.buildMessagePayload(context, messageType);
        try {
            Message message = new DefaultMessage(payload, this.buildMessageHeaders(context, messageType));
            message.setName(this.messageName);
            if (payload != null) {
                for (MessageConstructionInterceptor interceptor : context.getGlobalMessageConstructionInterceptors().getMessageConstructionInterceptors()) {
                    if (!direction.equals((Object)MessageDirection.UNBOUND) && !interceptor.getDirection().equals((Object)MessageDirection.UNBOUND) && !direction.equals((Object)interceptor.getDirection())) continue;
                    message = interceptor.interceptMessageConstruction(message, messageType, context);
                }
                if (this.dataDictionary != null) {
                    message = this.dataDictionary.interceptMessageConstruction(message, messageType, context);
                }
                for (MessageConstructionInterceptor interceptor : this.messageInterceptors) {
                    if (!direction.equals((Object)MessageDirection.UNBOUND) && !interceptor.getDirection().equals((Object)MessageDirection.UNBOUND) && !direction.equals((Object)interceptor.getDirection())) continue;
                    message = interceptor.interceptMessageConstruction(message, messageType, context);
                }
            }
            message.getHeaderData().addAll(this.buildMessageHeaderData(context));
            return message;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to build message content", e);
        }
    }

    public abstract Object buildMessagePayload(TestContext var1, String var2);

    public Map<String, Object> buildMessageHeaders(TestContext context, String messageType) {
        try {
            Map<String, Object> headers = context.resolveDynamicValuesInMap(this.messageHeaders);
            headers.put("citrus_message_type", messageType);
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                String value = entry.getValue().toString();
                if (!MessageHeaderType.isTyped(value)) continue;
                MessageHeaderType type = MessageHeaderType.fromTypedValue(value);
                Constructor<?> constr = type.getHeaderClass().getConstructor(String.class);
                entry.setValue(constr.newInstance(MessageHeaderType.removeTypeDefinition(value)));
            }
            MessageHeaderUtils.checkHeaderTypes(headers);
            return headers;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to build message content", e);
        }
    }

    public List<String> buildMessageHeaderData(TestContext context) {
        ArrayList<String> headerDataList = new ArrayList<String>();
        for (String headerResourcePath : this.headerResources) {
            try {
                headerDataList.add(context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(headerResourcePath, context), FileUtils.getCharset(headerResourcePath))));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read message header data resource", e);
            }
        }
        for (String data : this.headerData) {
            headerDataList.add(context.replaceDynamicContentInString(data.trim()));
        }
        return headerDataList;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public void setDataDictionary(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    public void setMessageHeaders(Map<String, Object> messageHeaders) {
        this.messageHeaders = messageHeaders;
    }

    public void setHeaderResources(List<String> headerResources) {
        this.headerResources = headerResources;
    }

    public void setHeaderData(List<String> headerData) {
        this.headerData = headerData;
    }

    public Map<String, Object> getMessageHeaders() {
        return this.messageHeaders;
    }

    public List<String> getHeaderResources() {
        return this.headerResources;
    }

    public List<String> getHeaderData() {
        return this.headerData;
    }

    @Override
    public void add(MessageConstructionInterceptor interceptor) {
        this.messageInterceptors.add(interceptor);
    }

    public List<MessageConstructionInterceptor> getMessageInterceptors() {
        return this.messageInterceptors;
    }

    public void setMessageInterceptors(List<MessageConstructionInterceptor> messageInterceptors) {
        this.messageInterceptors = messageInterceptors;
    }
}

