/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.util.TypeConversionUtils;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.Matcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ValidationUtils {
    private ValidationUtils() {
    }

    public static void validateValues(Object actualValue, Object expectedValue, String pathExpression, TestContext context) throws ValidationException {
        block21: {
            try {
                if (actualValue != null) {
                    Assert.isTrue((expectedValue != null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", null, actualValue));
                    if (expectedValue instanceof Matcher) {
                        Assert.isTrue((boolean)((Matcher)expectedValue).matches(actualValue), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not matching for element '" + pathExpression + "'", expectedValue, actualValue));
                        return;
                    }
                    if (!(expectedValue instanceof String)) {
                        Object converted = TypeConversionUtils.convertIfNecessary(actualValue, expectedValue.getClass());
                        if (converted == null) {
                            throw new CitrusRuntimeException(String.format("Failed to convert value '%s' to required type '%s'", actualValue, expectedValue.getClass()));
                        }
                        if (converted instanceof List) {
                            Assert.isTrue((boolean)converted.toString().equals(expectedValue.toString()), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue.toString(), converted.toString()));
                        } else if (converted instanceof String[]) {
                            String convertedDelimitedString = StringUtils.arrayToCommaDelimitedString((Object[])((String[])converted));
                            String expectedDelimitedString = StringUtils.arrayToCommaDelimitedString((Object[])((String[])expectedValue));
                            Assert.isTrue((boolean)convertedDelimitedString.equals(expectedDelimitedString), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedDelimitedString, convertedDelimitedString));
                        } else if (converted instanceof byte[]) {
                            String convertedBase64 = Base64.encodeBase64String((byte[])((byte[])converted));
                            String expectedBase64 = Base64.encodeBase64String((byte[])((byte[])expectedValue));
                            Assert.isTrue((boolean)convertedBase64.equals(expectedBase64), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedBase64, convertedBase64));
                        } else {
                            Assert.isTrue((boolean)converted.equals(expectedValue), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue, converted));
                        }
                    } else {
                        String actualValueString;
                        String expectedValueString = expectedValue.toString();
                        if (List.class.isAssignableFrom(actualValue.getClass())) {
                            actualValueString = StringUtils.arrayToCommaDelimitedString((Object[])((List)actualValue).toArray(new Object[((List)actualValue).size()]));
                            expectedValueString = expectedValueString.replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(",\\s", ",");
                        } else {
                            actualValueString = actualValue.toString();
                        }
                        if (ValidationMatcherUtils.isValidationMatcherExpression(String.valueOf(expectedValueString))) {
                            ValidationMatcherUtils.resolveValidationMatcher(pathExpression, actualValueString, String.valueOf(expectedValueString), context);
                        } else {
                            Assert.isTrue((boolean)actualValueString.equals(expectedValueString), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValueString, actualValueString));
                        }
                    }
                    break block21;
                }
                if (expectedValue == null) break block21;
                if (expectedValue instanceof Matcher) {
                    Assert.isTrue((boolean)((Matcher)expectedValue).matches(null), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not matching for element '" + pathExpression + "'", expectedValue, null));
                    break block21;
                }
                if (expectedValue instanceof String) {
                    String expectedValueString = expectedValue.toString();
                    if (ValidationMatcherUtils.isValidationMatcherExpression(expectedValueString)) {
                        ValidationMatcherUtils.resolveValidationMatcher(pathExpression, null, expectedValueString, context);
                    } else {
                        Assert.isTrue((!StringUtils.hasText((String)expectedValueString) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValueString, null));
                    }
                    break block21;
                }
                throw new ValidationException("Validation failed: " + ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue, null));
            }
            catch (AssertionError | IllegalArgumentException e) {
                throw new ValidationException("Validation failed:", (Throwable)e);
            }
        }
    }

    public static String buildValueMismatchErrorMessage(String baseMessage, Object controlValue, Object actualValue) {
        return baseMessage + ", expected '" + controlValue + "' but was '" + actualValue + "'";
    }
}

