/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.DefaultMessageHeaderValidator;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class MessageValidatorRegistry
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(MessageValidatorRegistry.class);
    public static final String BEAN_NAME = "citrusMessageValidatorRegistry";
    private List<MessageValidator<? extends ValidationContext>> messageValidators = new ArrayList<MessageValidator<? extends ValidationContext>>();

    public List<MessageValidator<? extends ValidationContext>> findMessageValidators(String messageType, Message message) {
        List<MessageValidator<? extends ValidationContext>> matchingValidators = new ArrayList<MessageValidator<? extends ValidationContext>>();
        for (MessageValidator<? extends ValidationContext> validator2 : this.messageValidators) {
            if (!validator2.supportsMessageType(messageType, message)) continue;
            matchingValidators.add(validator2);
        }
        if ((matchingValidators.isEmpty() || matchingValidators.stream().allMatch(validator -> DefaultMessageHeaderValidator.class.isAssignableFrom(validator.getClass()))) && message.getPayload() instanceof String && StringUtils.hasText((String)message.getPayload(String.class))) {
            String payload = message.getPayload(String.class).trim();
            if (payload.startsWith("<") && !messageType.equals(MessageType.XML.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.XML.name(), message);
            } else if ((payload.trim().startsWith("{") || payload.trim().startsWith("[")) && !messageType.equals(MessageType.JSON.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.JSON.name(), message);
            } else if (!messageType.equals(MessageType.PLAINTEXT.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.PLAINTEXT.name(), message);
            }
        }
        if (matchingValidators.isEmpty() || matchingValidators.stream().allMatch(validator -> DefaultMessageHeaderValidator.class.isAssignableFrom(validator.getClass()))) {
            throw new CitrusRuntimeException("Could not find proper message validator for message type '" + messageType + "', please define a capable message validator for this message type");
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Found %s message validators for message type: %s", matchingValidators.size(), messageType));
        }
        return matchingValidators;
    }

    private List<MessageValidator<? extends ValidationContext>> findFallbackMessageValidators(String messageType, Message message) {
        ArrayList<MessageValidator<? extends ValidationContext>> matchingValidators = new ArrayList<MessageValidator<? extends ValidationContext>>();
        for (MessageValidator<? extends ValidationContext> validator : this.messageValidators) {
            if (!validator.supportsMessageType(messageType, message)) continue;
            matchingValidators.add(validator);
        }
        return matchingValidators;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messageValidators.isEmpty()) {
            throw new CitrusRuntimeException("No message validators available in Spring bean context - please define message validators!");
        }
    }

    public void setMessageValidators(List<MessageValidator<? extends ValidationContext>> messageValidators) {
        this.messageValidators = messageValidators;
    }

    public List<MessageValidator<? extends ValidationContext>> getMessageValidators() {
        return this.messageValidators;
    }

    public MessageValidator getDefaultMessageHeaderValidator() {
        return this.messageValidators.stream().filter(validator -> DefaultMessageHeaderValidator.class.isAssignableFrom(validator.getClass())).findFirst().orElse(null);
    }
}

