/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathVariableExtractor;
import com.consol.citrus.validation.xml.XpathPayloadVariableExtractor;
import com.consol.citrus.variable.VariableExtractor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultPayloadVariableExtractor
implements VariableExtractor {
    private Map<String, String> pathExpressions = new HashMap<String, String>();
    private Map<String, String> namespaces = new HashMap<String, String>();
    private static Logger log = LoggerFactory.getLogger(DefaultPayloadVariableExtractor.class);

    @Override
    public void extractVariables(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.pathExpressions)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Reading path elements.");
        }
        JsonPathVariableExtractor jsonPathVariableExtractor = new JsonPathVariableExtractor();
        XpathPayloadVariableExtractor xpathPayloadVariableExtractor = new XpathPayloadVariableExtractor();
        if (!this.namespaces.isEmpty()) {
            xpathPayloadVariableExtractor.setNamespaces(this.namespaces);
        }
        LinkedHashMap<String, String> jsonPathExpressions = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> xpathExpressions = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> pathExpression : this.pathExpressions.entrySet()) {
            String path = context.replaceDynamicContentInString(pathExpression.getKey());
            String variable = pathExpression.getValue();
            if (JsonPathMessageValidationContext.isJsonPathExpression(path)) {
                jsonPathExpressions.put(path, variable);
                continue;
            }
            xpathExpressions.put(path, variable);
        }
        if (!jsonPathExpressions.isEmpty()) {
            jsonPathVariableExtractor.setJsonPathExpressions(jsonPathExpressions);
            jsonPathVariableExtractor.extractVariables(message, context);
        }
        if (!xpathExpressions.isEmpty()) {
            xpathPayloadVariableExtractor.setXpathExpressions(xpathExpressions);
            xpathPayloadVariableExtractor.extractVariables(message, context);
        }
    }

    public void setPathExpressions(Map<String, String> pathExpressions) {
        this.pathExpressions = pathExpressions;
    }

    public Map<String, String> getPathExpressions() {
        return this.pathExpressions;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }
}

