/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.util.TypeConversionUtils;
import com.consol.citrus.validation.HeaderValidator;
import com.consol.citrus.validation.ValidationUtils;
import com.consol.citrus.validation.context.HeaderValidationContext;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultHeaderValidator
implements HeaderValidator {
    private static Logger log = LoggerFactory.getLogger(DefaultHeaderValidator.class);

    @Override
    public void validateHeader(String headerName, Object receivedValue, Object controlValue, TestContext context, HeaderValidationContext validationContext) {
        if (controlValue instanceof Matcher) {
            Assert.isTrue((boolean)((Matcher)controlValue).matches(receivedValue), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not matching for header '" + headerName + "'", controlValue, receivedValue));
            return;
        }
        String expectedValue = Optional.ofNullable(controlValue).map(value -> TypeConversionUtils.convertIfNecessary(value, String.class)).map(context::replaceDynamicContentInString).orElse("");
        try {
            if (receivedValue != null) {
                String receivedValueString = TypeConversionUtils.convertIfNecessary(receivedValue, String.class);
                if (ValidationMatcherUtils.isValidationMatcherExpression(expectedValue)) {
                    ValidationMatcherUtils.resolveValidationMatcher(headerName, receivedValueString, expectedValue, context);
                    return;
                }
                Assert.isTrue((boolean)receivedValueString.equals(expectedValue), (String)("Values not equal for header element '" + headerName + "', expected '" + expectedValue + "' but was '" + receivedValue + "'"));
            } else {
                Assert.isTrue((!StringUtils.hasText((String)expectedValue) ? 1 : 0) != 0, (String)("Values not equal for header element '" + headerName + "', expected '" + expectedValue + "' but was '" + null + "'"));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Validation failed:", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating header element: " + headerName + "='" + expectedValue + "': OK.");
        }
    }

    @Override
    public boolean supports(String headerName, Class<?> type) {
        return true;
    }
}

