/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageValidator<T extends ValidationContext>
implements MessageValidator<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public final void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, List<ValidationContext> validationContexts) throws ValidationException {
        T validationContext = this.findValidationContext(validationContexts);
        if (validationContext != null) {
            this.validateMessage(receivedMessage, controlMessage, context, validationContext);
        }
    }

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, T validationContext) {
    }

    protected abstract Class<T> getRequiredValidationContextType();

    protected T findValidationContext(List<ValidationContext> validationContexts) {
        for (ValidationContext validationContext : validationContexts) {
            if (!this.getRequiredValidationContextType().isInstance(validationContext)) continue;
            return (T)validationContext;
        }
        return null;
    }
}

