/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class BooleanExpressionParser {
    private static final List<String> OPERATORS = new ArrayList<String>(CollectionUtils.arrayToList((Object)new String[]{"(", "=", "and", "or", "lt", "lt=", "gt", "gt=", ")"}));
    private static final List<String> BOOLEAN_VALUES = new ArrayList<String>(CollectionUtils.arrayToList((Object)new String[]{"true", "false"}));
    private static Logger log = LoggerFactory.getLogger(BooleanExpressionParser.class);

    private BooleanExpressionParser() {
    }

    /*
     * Unable to fully structure code
     */
    public static boolean evaluate(String expression) {
        operators = new Stack<String>();
        values = new Stack<String>();
        result = true;
lbl4:
        // 2 sources

        try {
            for (i = 0; i < expression.length(); ++i) {
                block14: {
                    actChar = expression.charAt(i);
                    if (actChar == '(') {
                        operators.push("(");
                        continue;
                    }
                    if (actChar == ' ') continue;
                    if (actChar != ')') break block14;
                    operator = (String)operators.pop();
                    while (!operator.equals("(")) {
                        values.push(BooleanExpressionParser.getBooleanResultAsString(operator, (String)values.pop(), (String)values.pop()));
                        operator = (String)operators.pop();
                    }
                    ** GOTO lbl4
                }
                if (!Character.isDigit(actChar)) {
                    operatorBuffer = new StringBuffer();
                    m = i;
                    do {
                        operatorBuffer.append(actChar);
                        if (++m >= expression.length()) continue;
                        actChar = expression.charAt(m);
                    } while (m < expression.length() && !Character.isDigit(actChar) && actChar != ' ' && actChar != '(');
                    i = m - 1;
                    if (BooleanExpressionParser.BOOLEAN_VALUES.contains(operatorBuffer.toString())) {
                        values.push(Boolean.valueOf(operatorBuffer.toString()) != false ? "1" : "0");
                        continue;
                    }
                    operators.push(BooleanExpressionParser.validateOperator(operatorBuffer.toString()));
                    continue;
                }
                if (!Character.isDigit(actChar)) continue;
                digitBuffer = new StringBuffer();
                m = i;
                do {
                    digitBuffer.append(actChar);
                    if (++m >= expression.length()) continue;
                    actChar = expression.charAt(m);
                } while (m < expression.length() && Character.isDigit(actChar));
                i = m - 1;
                values.push(digitBuffer.toString());
            }
            while (!operators.isEmpty()) {
                values.push(BooleanExpressionParser.getBooleanResultAsString((String)operators.pop(), (String)values.pop(), (String)values.pop()));
            }
            value = (String)values.pop();
            if (value.equals("0")) {
                value = "false";
            } else if (value.equals("1")) {
                value = "true";
            }
            result = Boolean.valueOf(value);
            if (BooleanExpressionParser.log.isDebugEnabled()) {
                BooleanExpressionParser.log.debug("Boolean expression " + expression + " evaluates to " + result);
            }
        }
        catch (EmptyStackException e) {
            throw new CitrusRuntimeException("Unable to parse boolean expression '" + expression + "'. Maybe expression is incomplete!", e);
        }
        return result;
    }

    private static String validateOperator(String operator) {
        if (!OPERATORS.contains(operator)) {
            throw new CitrusRuntimeException("Unknown operator '" + operator + "'");
        }
        return operator;
    }

    private static String getBooleanResultAsString(String operator, String value1, String value2) {
        if (operator.equals("lt")) {
            return Boolean.valueOf(Integer.valueOf(value2) < Integer.valueOf(value1)).toString();
        }
        if (operator.equals("lt=")) {
            return Boolean.valueOf(Integer.valueOf(value2) <= Integer.valueOf(value1)).toString();
        }
        if (operator.equals("gt")) {
            return Boolean.valueOf(Integer.valueOf(value2) > Integer.valueOf(value1)).toString();
        }
        if (operator.equals("gt=")) {
            return Boolean.valueOf(Integer.valueOf(value2) >= Integer.valueOf(value1)).toString();
        }
        if (operator.equals("=")) {
            return Boolean.valueOf(Integer.valueOf(value2).intValue() == Integer.valueOf(value1).intValue()).toString();
        }
        if (operator.equals("and")) {
            return Boolean.valueOf(Boolean.valueOf(value2) != false && Boolean.valueOf(value1) != false).toString();
        }
        if (operator.equals("or")) {
            return Boolean.valueOf(Boolean.valueOf(value2) != false || Boolean.valueOf(value1) != false).toString();
        }
        throw new CitrusRuntimeException("Unknown operator '" + operator + "'");
    }
}

