/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng;

import com.consol.citrus.TestClass;
import com.consol.citrus.main.AbstractTestEngine;
import com.consol.citrus.main.TestRunConfiguration;
import com.consol.citrus.main.scan.ClassPathTestScanner;
import com.consol.citrus.main.scan.JarFileTestScanner;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGEngine
extends AbstractTestEngine {
    private static Logger log = LoggerFactory.getLogger(TestNGEngine.class);
    private List<ITestNGListener> listeners = new ArrayList<ITestNGListener>();

    public TestNGEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        TestNG testng = new TestNG();
        for (ITestNGListener iTestNGListener : this.listeners) {
            testng.addListener(iTestNGListener);
        }
        XmlSuite suite = new XmlSuite();
        testng.setXmlSuites(Collections.singletonList(suite));
        if (!CollectionUtils.isEmpty(this.getConfiguration().getTestClasses())) {
            for (TestClass testClass2 : this.getConfiguration().getTestClasses()) {
                log.info(String.format("Running test %s", Optional.ofNullable(testClass2.getMethod()).map(method -> testClass2.getName() + "#" + method).orElse(testClass2.getName())));
                XmlTest test = new XmlTest(suite);
                test.setClasses(new ArrayList());
                try {
                    Class<?> clazz2;
                    if (this.getConfiguration().getTestJar() != null) {
                        Class<?> clazz3 = Class.forName(testClass2.getName(), false, new URLClassLoader(new URL[]{this.getConfiguration().getTestJar().toURI().toURL()}, this.getClass().getClassLoader()));
                    } else {
                        clazz2 = Class.forName(testClass2.getName());
                    }
                    XmlClass xmlClass = new XmlClass(clazz2);
                    if (StringUtils.hasText((String)testClass2.getMethod())) {
                        xmlClass.setIncludedMethods(Collections.singletonList(new XmlInclude(testClass2.getMethod())));
                    }
                    test.getClasses().add(xmlClass);
                }
                catch (ClassNotFoundException | MalformedURLException e) {
                    log.warn("Unable to read test class: " + testClass2.getName());
                }
            }
        } else {
            void var3_7;
            List<String> list = this.getConfiguration().getPackages();
            if (CollectionUtils.isEmpty(list)) {
                List<String> list2 = Collections.singletonList("");
                log.info("Running all tests in project");
            }
            for (String packageName : var3_7) {
                if (StringUtils.hasText((String)packageName)) {
                    log.info(String.format("Running tests in package %s", packageName));
                }
                XmlTest test = new XmlTest(suite);
                test.setClasses(new ArrayList());
                List<TestClass> classesToRun = this.getConfiguration().getTestJar() != null ? new JarFileTestScanner(this.getConfiguration().getTestJar(), this.getConfiguration().getIncludes()).findTestsInPackage(packageName) : new ClassPathTestScanner(Test.class, this.getConfiguration().getIncludes()).findTestsInPackage(packageName);
                classesToRun.stream().peek(testClass -> log.info(String.format("Running test %s", Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElse(testClass.getName())))).map(testClass -> {
                    try {
                        Class<?> clazz = this.getConfiguration().getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{this.getConfiguration().getTestJar().toURI().toURL()}, this.getClass().getClassLoader())) : Class.forName(testClass.getName());
                        return clazz;
                    }
                    catch (ClassNotFoundException | MalformedURLException e) {
                        log.warn("Unable to read test class: " + testClass.getName());
                        return Void.class;
                    }
                }).filter(clazz -> !clazz.equals(Void.class)).map(XmlClass::new).forEach(test.getClasses()::add);
                log.info(String.format("Found %s test classes to execute", test.getClasses().size()));
            }
        }
        testng.run();
    }

    public TestNGEngine addTestListener(ITestNGListener listener) {
        this.listeners.add(listener);
        return this;
    }
}

