/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.server;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.server.Server;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerShutdownThread
extends Thread {
    private static Logger log = LoggerFactory.getLogger(ServerShutdownThread.class);
    private List<Server> servers = new ArrayList<Server>();
    private boolean done = false;

    @Override
    public void run() {
        log.debug("ShutdownThread running ...");
        try {
            for (Server server : this.servers) {
                server.stop();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error("Thread was interrupted", (Throwable)e);
                }
            }
        }
        catch (CitrusRuntimeException e) {
            log.error("Error while shutting down server", (Throwable)e);
        }
    }

    private void create() {
        if (!this.done) {
            Runtime.getRuntime().addShutdownHook(this);
            this.done = true;
        }
    }

    public ServerShutdownThread(Server server) {
        this.create();
        this.servers.add(server);
    }

    public ServerShutdownThread(List<Server> servers) {
        this.create();
        this.servers.addAll(servers);
    }

    public void add(Server server) {
        this.create();
        this.servers.add(server);
    }
}

