/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.server;

import com.consol.citrus.channel.ChannelEndpointAdapter;
import com.consol.citrus.channel.ChannelSyncEndpointConfiguration;
import com.consol.citrus.channel.MessageSelectingQueueChannel;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.server.Server;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageChannel;

public abstract class AbstractServer
extends AbstractEndpoint
implements Server,
InitializingBean,
DisposableBean,
BeanFactoryAware {
    public static final String DEFAULT_CHANNEL_ID_SUFFIX = ".inbound";
    private boolean running = false;
    private boolean autoStart = false;
    private Thread thread;
    private final Object runningLock = new Object();
    private BeanFactory beanFactory;
    private EndpointAdapter endpointAdapter;
    private List<Object> interceptors = new ArrayList<Object>();
    private long defaultTimeout = 1000L;
    @Autowired
    private TestContextFactory testContextFactory;
    private boolean debugLogging = false;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractServer() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting server: " + this.getName() + " ...");
        }
        this.startup();
        Object object = this.runningLock;
        synchronized (object) {
            this.running = true;
        }
        this.thread = new Thread(this);
        this.thread.setDaemon(false);
        this.thread.start();
        this.log.info("Started server: " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping server: " + this.getName() + " ...");
        }
        this.shutdown();
        Object object = this.runningLock;
        synchronized (object) {
            this.running = false;
        }
        this.thread = null;
        this.log.info("Stopped server: " + this.getName());
    }

    @Override
    public void run() {
    }

    protected abstract void startup();

    protected abstract void shutdown();

    public void afterPropertiesSet() throws Exception {
        if (this.endpointAdapter == null) {
            MessageSelectingQueueChannel inboundChannel;
            if (this.beanFactory != null && this.beanFactory.containsBean(this.getName() + DEFAULT_CHANNEL_ID_SUFFIX)) {
                inboundChannel = (MessageSelectingQueueChannel)((Object)this.beanFactory.getBean(this.getName() + DEFAULT_CHANNEL_ID_SUFFIX, MessageSelectingQueueChannel.class));
            } else {
                inboundChannel = new MessageSelectingQueueChannel();
                inboundChannel.setBeanName(this.getName() + DEFAULT_CHANNEL_ID_SUFFIX);
            }
            inboundChannel.setLoggingEnabled(this.debugLogging);
            ChannelSyncEndpointConfiguration channelEndpointConfiguration = new ChannelSyncEndpointConfiguration();
            channelEndpointConfiguration.setChannel((MessageChannel)inboundChannel);
            channelEndpointConfiguration.setBeanFactory(this.getBeanFactory());
            channelEndpointConfiguration.setTimeout(this.defaultTimeout);
            channelEndpointConfiguration.setUseObjectMessages(true);
            this.endpointAdapter = new ChannelEndpointAdapter(channelEndpointConfiguration);
            this.endpointAdapter.getEndpoint().setName(this.getName());
            if (this.testContextFactory == null) {
                if (this.beanFactory != null) {
                    this.testContextFactory = (TestContextFactory)this.beanFactory.getBean(TestContextFactory.class);
                } else {
                    this.log.warn("Unable to create test context factory from Spring application context - using minimal test context factory");
                    this.testContextFactory = new TestContextFactory();
                }
            }
            ((ChannelEndpointAdapter)this.endpointAdapter).setTestContextFactory(this.testContextFactory);
        }
        if (this.autoStart && !this.isRunning()) {
            this.start();
        }
    }

    public void destroy() throws Exception {
        if (this.isRunning()) {
            this.shutdown();
        }
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            this.log.error("Error occured", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.runningLock;
        synchronized (object) {
            return this.running;
        }
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointAdapter.getEndpoint().getEndpointConfiguration();
    }

    @Override
    public Consumer createConsumer() {
        return this.endpointAdapter.getEndpoint().createConsumer();
    }

    @Override
    public Producer createProducer() {
        return this.endpointAdapter.getEndpoint().createProducer();
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public EndpointAdapter getEndpointAdapter() {
        return this.endpointAdapter;
    }

    public void setEndpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpointAdapter = endpointAdapter;
    }

    public List<Object> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Object> interceptors) {
        this.interceptors = interceptors;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setDebugLogging(boolean debugLogging) {
        this.debugLogging = debugLogging;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }
}

